/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.tag;

import de.intarsys.html.IHtmlTag;
import de.intarsys.html.IHtmlTagImpl;
import de.intarsys.layout.CBorderPolicy;
import de.intarsys.layout.ILayoutComponent;
import de.intarsys.pdf.layout.html.model.PDLTableCell;
import de.intarsys.pdf.layout.html.model.TableCell;
import de.intarsys.pdf.layout.html.parser.PDLHtmlHandler;
import de.intarsys.pdf.layout.html.parser.PDLHtmlTag;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagList;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagTableRow;
import de.intarsys.pdf.layout.pad.IPDLTextPad;
import de.intarsys.pdf.layout.pad.PDLLayouter;
import de.intarsys.pdf.layout.pad.PDLParagraphFormat;
import de.intarsys.pdf.layout.pad.PDLTextFormat;
import de.intarsys.pdf.layout.pad.PDLTextPad;
import de.intarsys.pdf.layout.parser.PDLParseException;
import java.awt.geom.Rectangle2D;

public class PDLHtmlTagLI
extends PDLHtmlTagTableRow {
    private TableCell cell;
    private IPDLTextPad cellPad;

    public PDLHtmlTagLI(PDLHtmlHandler handler, PDLHtmlTag parent, IHtmlTag htmlTag) {
        super(handler, parent, htmlTag);
    }

    protected void createCellElements() {
        IPDLTextPad pad = this.getCellPad();
        this.setCellPad(null);
        pad.close();
        Rectangle2D rect = pad.getLayoutContainer().getBoundingBox();
        float contentHeigth = (float)rect.getHeight();
        this.getCell().setContentHeight(contentHeigth);
        PDLTableCell pdeCell = new PDLTableCell(this.getCell(), (ILayoutComponent)pad.getLayoutContainer());
        this.addCell(pdeCell);
        this.getCell().setDescent(this.getPDEParser().getLineDescent());
    }

    protected void endCell() throws PDLParseException {
        this.createCellElements();
        this.setAfterTextLine(false);
        this.getPDEParser().resetCurrentAscentDescent();
        this.endCellPad();
        this.setCell(null);
    }

    protected final void endCellPad() throws PDLParseException {
        PDLLayouter layouter;
        PDLParagraphFormat paragraphFormat;
        IPDLTextPad activePad = this.getActivePad();
        PDLTextFormat textFormat = this.endedCustomizeTextFormat(activePad);
        if (textFormat != null) {
            activePad.setTextFormat(textFormat);
            this.setPreviousTextFormat(null);
        }
        if ((paragraphFormat = this.endedCustomizeParagraphFormat(activePad)) != null) {
            activePad.setParagraphFormat(paragraphFormat);
            this.setPreviousParagraphFormat(null);
        }
        if ((layouter = this.endedCustomizeLayouter(activePad)) != null) {
            activePad.setLayouter(layouter);
            this.setPreviousLayouter(null);
        }
    }

    @Override
    public void ended() throws PDLParseException {
        this.endCell();
        super.ended();
    }

    @Override
    protected IPDLTextPad getActivePad() {
        if (this.getCellPad() == null) {
            return super.getActivePad();
        }
        return this.getCellPad();
    }

    protected TableCell getCell() {
        return this.cell;
    }

    protected IPDLTextPad getCellPad() {
        return this.cellPad;
    }

    protected String getListItemDescription() {
        PDLHtmlTagList listTag = this.getParentList();
        if (listTag == null) {
            return "?";
        }
        return listTag.getListItemDescription();
    }

    protected PDLHtmlTagList getParentList() {
        IHtmlTagImpl tag;
        for (tag = this.getParent(); tag != null && !(tag instanceof PDLHtmlTagList); tag = tag.getParent()) {
        }
        return (PDLHtmlTagList)tag;
    }

    protected void setCell(TableCell cell) {
        this.cell = cell;
    }

    protected void setCellPad(IPDLTextPad cellPad) {
        this.cellPad = cellPad;
    }

    protected void startCell() throws PDLParseException {
        TableCell cell = new TableCell(this.getRow());
        this.setCell(cell);
        this.setAfterTextLine(false);
        this.getPDEParser().setParagraphFound(true);
        this.getPDEParser().resetCurrentAscentDescent();
        this.startCellPad();
    }

    protected void startCellPad() {
        IPDLTextPad pad = this.getActivePad();
        if (pad == null) {
            return;
        }
        PDLTextFormat newTextFormat = this.startedCellCustomizeTextFormat(pad);
        PDLParagraphFormat newParagraphFormat = this.startedCellCustomizeParagraphFormat(pad);
        PDLLayouter newLayouter = this.startedCellCustomizeLayouter(pad);
        PDLTextPad newPad = new PDLTextPad(newTextFormat, newParagraphFormat, newLayouter);
        this.setCellPad(newPad);
    }

    @Override
    public void started() throws PDLParseException {
        super.started();
        this.startCell();
        char[] listItemDescription = this.getListItemDescription().toCharArray();
        this.text(listItemDescription, 0, listItemDescription.length);
        this.getPDEParser().flush();
        this.endCell();
        this.startCell();
        this.endCell();
        this.startCell();
    }

    protected PDLLayouter startedCellCustomizeLayouter(IPDLTextPad pad) {
        float unused = this.getCell().getNonContentWidth();
        float width = Math.max(this.getCell().getColumnWidth() - unused, 0.0f);
        Rectangle2D.Float bbox = new Rectangle2D.Float(0.0f, 0.0f, width, 0.0f);
        PDLLayouter result = new PDLLayouter(bbox);
        result.setPrimaryBorderPolicy(CBorderPolicy.FIX);
        result.setSecondaryBorderPolicy(CBorderPolicy.GROW);
        return result;
    }

    protected PDLParagraphFormat startedCellCustomizeParagraphFormat(IPDLTextPad pad) {
        PDLParagraphFormat result = pad.getParagraphFormat().copy();
        result.setHAlignment(this.getCell().getHAlignment());
        result.setVAlignment(this.getCell().getVAlignment());
        return result;
    }

    protected PDLTextFormat startedCellCustomizeTextFormat(IPDLTextPad pad) {
        PDLTextFormat result = pad.getTextFormat();
        return result;
    }
}

