/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.tag;

import de.intarsys.html.IHtmlTag;
import de.intarsys.html.IHtmlTagImpl;
import de.intarsys.layout.CBorderPolicy;
import de.intarsys.layout.ILayoutComponent;
import de.intarsys.pdf.layout.html.model.PDLTableCell;
import de.intarsys.pdf.layout.html.model.TableCell;
import de.intarsys.pdf.layout.html.model.TableRow;
import de.intarsys.pdf.layout.html.parser.PDLHtmlHandler;
import de.intarsys.pdf.layout.html.parser.PDLHtmlTag;
import de.intarsys.pdf.layout.html.tag.PDLHtmlTagTR;
import de.intarsys.pdf.layout.pad.IPDLTextPad;
import de.intarsys.pdf.layout.pad.PDLLayouter;
import de.intarsys.pdf.layout.pad.PDLParagraphFormat;
import de.intarsys.pdf.layout.parser.PDLParseException;
import java.awt.geom.Rectangle2D;

public class PDLHtmlTagTableCell
extends PDLHtmlTag {
    public PDLHtmlTagTableCell(PDLHtmlHandler handler, PDLHtmlTag parent, IHtmlTag htmlTag) {
        super(handler, parent, htmlTag, new TableCell((TableRow)parent.getHtmlElement(), htmlTag.getAttribute("colspan") == null ? 1 : Integer.parseInt(htmlTag.getAttribute("colspan"))));
    }

    protected void createCellElements() {
        IPDLTextPad pad = this.getLocalPad();
        this.setLocalPad(null);
        pad.close();
        Rectangle2D rect = pad.getLayoutContainer().getBoundingBox();
        float contentHeigth = (float)rect.getHeight();
        this.getCell().setContentHeight(contentHeigth);
        if (!this.getCell().getFirstColumn().isHorizontalExtensionValueDefined()) {
            float contentWidth = (float)rect.getWidth();
            this.getCell().setContentWidth(contentWidth);
        }
        PDLTableCell pdeCell = new PDLTableCell(this.getCell(), (ILayoutComponent)pad.getLayoutContainer());
        this.getParentRow().addCell(pdeCell);
        this.getCell().setDescent(this.getPDEParser().getLineDescent());
    }

    @Override
    public void ended() throws PDLParseException {
        this.createCellElements();
        this.setAfterTextLine(false);
        this.getPDEParser().resetCurrentAscentDescent();
        super.ended();
    }

    protected TableCell getCell() {
        return (TableCell)this.getHtmlElement();
    }

    protected PDLHtmlTagTR getParentRow() {
        IHtmlTagImpl tag;
        for (tag = this.getParent(); tag != null && !(tag instanceof PDLHtmlTagTR); tag = tag.getParent()) {
        }
        return (PDLHtmlTagTR)tag;
    }

    @Override
    protected boolean isBreak() {
        return false;
    }

    @Override
    protected boolean isCreateNewPad() {
        return true;
    }

    @Override
    public void started() throws PDLParseException {
        this.setAfterTextLine(false);
        this.getPDEParser().setParagraphFound(true);
        this.getPDEParser().resetCurrentAscentDescent();
        String bgcolorDefinition = this.getHtmlTag().getAttribute("bgcolor");
        this.getCell().defineBgColor(bgcolorDefinition);
        String valignDefinition = this.getHtmlTag().getAttribute("valign");
        this.getCell().defineVAlign(valignDefinition);
        String halignDefinition = this.getHtmlTag().getAttribute("align");
        this.getCell().defineAlign(halignDefinition);
        this.getCell().defineStyle(this.getStyle());
        super.started();
    }

    @Override
    protected PDLLayouter startedCustomizeLayouter(IPDLTextPad pad) {
        float unused = this.getCell().getNonContentWidth();
        float width = Math.max(this.getCell().getColumnWidth() - unused, 0.0f);
        float height = 0.0f;
        if (this.getCell().isVerticalExtensionValueDefined()) {
            height = Math.max(this.getCell().getContentHeight(), 0.0f);
        }
        Rectangle2D.Float bbox = new Rectangle2D.Float(0.0f, 0.0f, width, height);
        PDLLayouter result = new PDLLayouter(bbox);
        if (this.getCell().getFirstColumn().isHorizontalExtensionValueDefined()) {
            result.setPrimaryBorderPolicy(CBorderPolicy.FIX);
        } else {
            result.setPrimaryBorderPolicy(CBorderPolicy.GROW);
        }
        if (this.getCell().isVerticalExtensionValueDefined()) {
            result.setSecondaryBorderPolicy(CBorderPolicy.FIX);
        } else {
            result.setSecondaryBorderPolicy(CBorderPolicy.GROW);
        }
        return result;
    }

    @Override
    protected PDLParagraphFormat startedCustomizeParagraphFormat(IPDLTextPad pad) {
        PDLParagraphFormat result = pad.getParagraphFormat().copy();
        result.setHAlignment(this.getCell().getHAlignment());
        result.setVAlignment(this.getCell().getVAlignment());
        return result;
    }
}

