/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.html.tag;

import de.intarsys.html.IHtmlTag;
import de.intarsys.pdf.layout.html.model.PDLTableRow;
import de.intarsys.pdf.layout.html.model.PDLTableStart;
import de.intarsys.pdf.layout.html.model.Table;
import de.intarsys.pdf.layout.html.model.TableSegment;
import de.intarsys.pdf.layout.html.parser.PDLHtmlHandler;
import de.intarsys.pdf.layout.html.parser.PDLHtmlTag;
import de.intarsys.pdf.layout.parser.PDLParseException;
import java.util.List;

public abstract class PDLHtmlTagTabular
extends PDLHtmlTag {
    protected PDLHtmlTagTabular(PDLHtmlHandler handler, PDLHtmlTag parent, IHtmlTag htmlTag) {
        super(handler, parent, htmlTag, new Table(parent.getHtmlElement()));
    }

    protected void addBodyRow(PDLTableRow row) throws PDLParseException {
        this.layoutRow(row);
    }

    protected void basicEnded() throws PDLParseException {
    }

    protected void basicReplayOverflow(List overflow) throws PDLParseException {
    }

    @Override
    public void ended() throws PDLParseException {
        this.basicEnded();
        PDLTableStart start = (PDLTableStart)this.getActivePad().getAttribute("tablestart");
        this.getActivePad().layoutElement(start.getEnd());
        this.endCurrentLine(false);
        this.setAfterTextLine(false);
        this.getPDEParser().resetCurrentAscentDescent();
        super.ended();
    }

    protected Table getTable() {
        return (Table)this.getHtmlElement();
    }

    @Override
    public TableSegment getTableRowParent() {
        return this.getTable().getBody();
    }

    @Override
    protected boolean isBreak() {
        return true;
    }

    protected void layoutRow(PDLTableRow row) throws PDLParseException {
        this.getActivePad().layoutElement(row);
        this.getPDEParser().checkOverflow();
        this.endCurrentLine(false);
        PDLTableStart pdeStart = (PDLTableStart)this.getActivePad().getAttribute("tablestart");
        pdeStart.addRow(row.getLowMost());
    }

    protected void layoutRows(List rows) throws PDLParseException {
        for (PDLTableRow row : rows) {
            this.layoutRow(row);
        }
    }

    @Override
    public void replayOverflow(List overflow) throws PDLParseException {
        PDLTableStart newStart = new PDLTableStart(this.getTable());
        this.getActivePad().setAttribute("tablestart", newStart);
        this.getActivePad().layoutElement(newStart);
        this.endCurrentLine(false);
        this.basicReplayOverflow(overflow);
        super.replayOverflow(overflow);
    }

    @Override
    public void started() throws PDLParseException {
        if (this.isAfterTextLine()) {
            this.getTable().setTopMargin(-this.getPDEParser().getLineDescent() + 2.0f);
        }
        this.getPDEParser().resetCurrentAscentDescent();
        super.started();
        this.startedCustomizeTable(this.getTable());
        PDLTableStart newStart = new PDLTableStart(this.getTable());
        this.getActivePad().setAttribute("tablestart", newStart);
        this.getActivePad().layoutElement(newStart);
        this.endCurrentLine(false);
    }

    protected void startedCustomizeTable(Table table) {
    }
}

