/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.pad;

import de.intarsys.layout.CAlignment;
import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.TextLayouter;
import de.intarsys.pdf.layout.element.PDLCR;
import de.intarsys.pdf.layout.element.PDLFF;
import de.intarsys.pdf.layout.element.PDLLF;
import de.intarsys.pdf.layout.element.PDLLineStart;
import de.intarsys.pdf.layout.element.PDLTab;
import de.intarsys.pdf.layout.element.PDLTextRun;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class PDLLayouter {
    private ILayoutComponent lastElement = null;
    private TextLayouter layouter;
    private List overflow;

    public PDLLayouter(Rectangle2D rect) {
        this.layouter = new TextLayouter(rect);
        this.reset();
    }

    public void close() {
        if (this.getLastElement() instanceof PDLTab) {
            PDLTab tab = (PDLTab)this.getLastElement();
            this.getLayouter().add((ILayoutComponent)tab, false);
            this.setLastElement(null);
            for (ILayoutComponent trailElement : tab.getTrailElements()) {
                this.layoutElement(trailElement);
            }
        }
        this.setOverflow(this.getLayouter().close());
    }

    public Rectangle2D getBoundingBox() {
        return this.getLayouter().getBoundingBox();
    }

    protected ILayoutComponent getLastElement() {
        return this.lastElement;
    }

    public TextLayouter getLayouter() {
        return this.layouter;
    }

    public Point2D getLayoutPosition() {
        return this.layouter.getLayoutPosition();
    }

    public List getOverflow() {
        return this.overflow;
    }

    public boolean isReplayMode() {
        return this.layouter.isReplayMode();
    }

    public void layoutElement(ILayoutComponent component) {
        PDLTab tab;
        component.resetLayout();
        if (this.getLastElement() instanceof PDLLineStart && component instanceof PDLLineStart) {
            return;
        }
        if (this.getLastElement() instanceof PDLTab) {
            tab = (PDLTab)this.getLastElement();
            if (!tab.addTrailElement(component)) {
                this.getLayouter().add((ILayoutComponent)tab, false);
                this.setLastElement(null);
                for (ILayoutComponent trailElement : tab.getTrailElements()) {
                    this.layoutElement(trailElement);
                }
                if (this.getLastElement() == null) {
                    this.setLastElement(tab);
                }
            } else {
                return;
            }
        }
        if (component instanceof PDLTab) {
            tab = (PDLTab)component;
            tab.setPreviousElement(this.getLastElement());
            tab.setOffset((float)this.getBoundingBox().getMinX());
        }
        if (component instanceof PDLCR) {
            return;
        }
        this.setLastElement(component);
        if (component instanceof PDLTab) {
            return;
        }
        if (component instanceof PDLTextRun) {
            this.getLayouter().setDirection(((PDLTextRun)component).getDirection());
        }
        this.setOverflow(this.getLayouter().add(component, component.isForced()));
        if (component instanceof PDLLF || component instanceof PDLFF) {
            this.newLine();
            if (this.getOverflow() == null && component instanceof PDLFF) {
                ArrayList<PDLLineStart> tempOver = new ArrayList<PDLLineStart>();
                tempOver.add(new PDLLineStart());
                this.setOverflow(tempOver);
            }
        }
    }

    protected void newLine() {
        this.setLastElement(null);
        this.setOverflow(this.getLayouter().newLine(true));
        if (this.getOverflow() == null) {
            this.layoutElement(new PDLLineStart());
        }
    }

    public void removeLast() {
        this.layouter.removeLast();
    }

    protected void reset() {
        this.setOverflow(null);
    }

    public void setHAlignment(int i) {
        if (i == CAlignment.UNDEFINED) {
            return;
        }
        this.getLayouter().setPrimaryAlignment(i);
    }

    protected void setLastElement(ILayoutComponent component) {
        this.lastElement = component;
    }

    public void setLayoutPosition(float x, float y) {
        this.getLayouter().setLayoutPosition(x, y);
    }

    public void setMaxlines(int maxlines) {
        this.getLayouter().setMaxlines(maxlines);
    }

    protected void setOverflow(List list) {
        this.overflow = list;
    }

    public void setPrimaryBorderPolicy(int primaryBorderPolicy) {
        this.layouter.setPrimaryBorderPolicy(primaryBorderPolicy);
    }

    public void setReplayMode(boolean replayMode) {
        this.layouter.setReplayMode(replayMode);
    }

    public void setSecondaryBorderPolicy(int secondaryBorderPolicy) {
        this.layouter.setSecondaryBorderPolicy(secondaryBorderPolicy);
    }

    public void setVAlignment(int i) {
        this.getLayouter().setSecondaryAlignment(i);
    }
}

