/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.pad;

import de.intarsys.pdf.layout.element.PDLTab;
import de.intarsys.pdf.layout.pad.PDLTabStop;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class PDLTabSet {
    private List tabStops = new ArrayList();

    public PDLTabSet() {
    }

    public PDLTabSet(String tabSetDefinition) {
        this();
        this.define(tabSetDefinition);
    }

    public void addTabStop(float position) {
        this.addTabStop(new PDLTabStop(position));
    }

    public void addTabStop(PDLTabStop ts) {
        this.tabStops.add(ts);
    }

    protected void define(String definition) {
        StringTokenizer st = new StringTokenizer(definition, "#");
        int tabPos = 0;
        while (st.hasMoreTokens()) {
            String tabDefinition = st.nextToken().trim();
            if (tabDefinition.length() <= 0) continue;
            int tabAlignment = Character.toLowerCase(tabDefinition.charAt(tabDefinition.length() - 1));
            if (Character.isDigit((char)tabAlignment)) {
                tabAlignment = 108;
            } else {
                tabDefinition = tabDefinition.substring(0, tabDefinition.length() - 1);
            }
            try {
                tabPos = Integer.parseInt(tabDefinition);
            }
            catch (Exception e) {
                tabPos = (int)((float)tabPos + PDLTab.DEFAULT_TABWIDTH);
            }
            PDLTabStop tabStop = new PDLTabStop(tabPos);
            if (tabAlignment == 108) {
                tabStop.setLeftAligned();
            } else if (tabAlignment == 99) {
                tabStop.setCenterAligned();
            } else if (tabAlignment == 114) {
                tabStop.setRightAligned();
            }
            this.addTabStop(tabStop);
        }
    }

    public PDLTabStop findNext(double pos) {
        for (PDLTabStop tabStop : this.getTabStops()) {
            if (!((double)tabStop.getPosition() > pos + 1.0)) continue;
            return tabStop;
        }
        return null;
    }

    public List getTabStops() {
        return this.tabStops;
    }
}

