/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.pad;

import de.intarsys.pdf.app.appearance.ITextFormatProvider;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;

public class PDLTextFormat
implements ITextFormatProvider {
    private static final float THOUSAND = 1000.0f;
    private float[] color;
    private float fixedWidth = Float.NaN;
    private PDFont font;
    private float fontSize;
    private float leading;
    private float moveY = 0.0f;
    private float scaledAscent;
    private float scaledDescent;
    private float scaledHeight;
    private boolean strike = false;
    private boolean underline = false;
    private boolean autoFontSize = false;

    public PDLTextFormat copy() {
        PDLTextFormat result = new PDLTextFormat();
        result.setFont(this.getFont());
        result.setFontSize(this.getFontSize());
        result.setUnderline(this.isUnderline());
        result.setLeading(this.getLeading());
        result.setMoveY(this.getMoveY());
        result.setStrike(this.isStrike());
        result.setColor(this.getColor());
        result.setFixedWidth(this.getFixedWidth());
        return result;
    }

    public float[] getColor() {
        return this.color;
    }

    public float getFixedWidth() {
        return this.fixedWidth;
    }

    public PDFont getFont() {
        return this.font;
    }

    public float[] getFontColor() {
        return this.color;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public float getGlyphWidthEncoded(byte[] bytes, int offset, int length) {
        return PDFontTools.getGlyphWidthEncodedScaled((PDFont)this.getFont(), (float)this.getFontSize(), (byte[])bytes, (int)offset, (int)length);
    }

    public float getLeading() {
        return this.leading;
    }

    public float getMoveY() {
        return this.moveY;
    }

    public float getRenderingWidth(byte[] bytes, int offset, int length) {
        if (this.isFixedWidth()) {
            return this.getFixedWidth() * (float)bytes.length;
        }
        return this.getGlyphWidthEncoded(bytes, offset, length);
    }

    public float getScaledFontAscent() {
        if (this.scaledAscent == 0.0f) {
            this.scaledAscent = this.getFont().getFontDescriptor().getAscent();
            this.scaledAscent = this.scaledAscent == 0.0f ? this.getScaledFontHeight() / 3.0f * 2.0f : this.getFontSize() * this.scaledAscent / 1000.0f;
        }
        return this.scaledAscent;
    }

    public float getScaledFontDescent() {
        if (this.scaledDescent == 0.0f) {
            this.scaledDescent = this.getFont().getFontDescriptor().getDescent();
            this.scaledDescent = this.scaledDescent == 0.0f ? this.getScaledFontHeight() / 3.0f : this.getFontSize() * this.scaledDescent / 1000.0f;
        }
        return this.scaledDescent;
    }

    public float getScaledFontHeight() {
        if (this.scaledHeight == 0.0f) {
            this.scaledHeight = this.getLeading();
            if (this.scaledHeight == 0.0f) {
                this.scaledHeight = this.getFont().getFontDescriptor().getLeading();
                if (this.scaledHeight == 0.0f) {
                    CDSRectangle rect = this.getFont().getFontDescriptor().getFontBB();
                    this.scaledHeight = rect == null ? this.getFont().getFontDescriptor().getXHeight() : rect.getUpperRightY() - rect.getLowerLeftY();
                }
                this.scaledHeight = this.getFontSize() * this.scaledHeight / 1000.0f;
            }
        }
        return this.scaledHeight;
    }

    protected void invalidateCache() {
        this.scaledAscent = 0.0f;
        this.scaledHeight = 0.0f;
        this.scaledDescent = 0.0f;
    }

    public boolean isAutoFontSize() {
        return this.autoFontSize;
    }

    public boolean isFixedWidth() {
        return !Float.isNaN(this.fixedWidth);
    }

    public boolean isFont(PDFont queryFont, float queryFontSize) {
        return this.font != null && this.font.equals(queryFont) && this.fontSize == queryFontSize;
    }

    public boolean isStrike() {
        return this.strike;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setAutoFontSize(boolean autoFontSize) {
        this.autoFontSize = autoFontSize;
    }

    public void setColor(float[] color) {
        this.color = color;
    }

    public void setFixedWidth(float fixedWidth) {
        this.fixedWidth = fixedWidth;
    }

    public void setFont(PDFont font) {
        this.font = font;
        this.invalidateCache();
    }

    public void setFontSize(float d) {
        this.fontSize = d;
        this.invalidateCache();
    }

    public void setLeading(float leading) {
        this.leading = leading;
    }

    public void setMoveY(float moveY) {
        this.moveY = moveY;
    }

    public void setStrike(boolean strike) {
        this.strike = strike;
    }

    public void setUnderline(boolean b) {
        this.underline = b;
    }
}

