/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.pad;

import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.ILayoutContainer;
import de.intarsys.layout.ILayoutVisitor;
import de.intarsys.layout.LayoutContainer;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.layout.element.PDLElement;
import de.intarsys.pdf.layout.element.PDLTextElement;
import de.intarsys.pdf.layout.pad.IPDLTextPad;
import de.intarsys.pdf.layout.pad.PDLLayouter;
import de.intarsys.pdf.layout.pad.PDLParagraphFormat;
import de.intarsys.pdf.layout.pad.PDLTextFormat;
import de.intarsys.tools.attribute.AttributeMap;
import java.util.List;

public class PDLTextPad
implements IPDLTextPad {
    private LayoutContainer layoutContainer = new LayoutContainer();
    private AttributeMap attributes;
    private PDLLayouter layouter;
    private PDLParagraphFormat paragraphFormat;
    private PDLTextFormat textFormat;

    public PDLTextPad(PDLTextFormat textFormat, PDLParagraphFormat paragraphFormat, PDLLayouter layouter) {
        this.setTextFormat(textFormat);
        this.setParagraphFormat(paragraphFormat);
        this.setLayouter(layouter);
    }

    @Override
    public void close() {
        this.flush();
        this.getLayoutContainer().trim();
    }

    @Override
    public PDLElement createTextElement(char[] text, int off, int len, int directionality) {
        PDLTextElement result = PDLTextElement.createTextElement(this, text, off, len, directionality);
        return result;
    }

    protected void flush() {
        if (this.getLayouter() != null) {
            this.getLayouter().close();
        }
    }

    public final Object getAttribute(Object key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    @Override
    public ILayoutContainer getLayoutContainer() {
        return this.layoutContainer;
    }

    @Override
    public PDLLayouter getLayouter() {
        return this.layouter;
    }

    @Override
    public List getOverflow() {
        return this.getLayouter().getOverflow();
    }

    @Override
    public PDLParagraphFormat getParagraphFormat() {
        return this.paragraphFormat;
    }

    @Override
    public PDLTextFormat getTextFormat() {
        return this.textFormat;
    }

    @Override
    public void layoutElement(ILayoutComponent component) {
        this.getLayouter().layoutElement(component);
    }

    public final Object removeAttribute(Object key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(key);
    }

    @Override
    public void removeLastElement() {
        this.getLayouter().removeLast();
    }

    public final Object setAttribute(Object key, Object value) {
        if (this.attributes == null) {
            this.attributes = new AttributeMap();
        }
        return this.attributes.put(key, value);
    }

    @Override
    public void setLayouter(PDLLayouter newLayouter) {
        this.flush();
        PDLLayouter oldLayouter = this.layouter;
        this.layouter = newLayouter;
        if (this.getLayouter() != null && this.getParagraphFormat() != null) {
            this.getLayouter().setHAlignment(this.getParagraphFormat().getHAlignment());
            this.getLayouter().setVAlignment(this.getParagraphFormat().getVAlignment());
            this.getLayouter().setMaxlines(this.getParagraphFormat().getMaxlines());
        }
        if (oldLayouter != newLayouter && newLayouter != null) {
            this.getLayoutContainer().add((ILayoutComponent)this.getLayouter().getLayouter().getLayoutContainer());
        }
    }

    @Override
    public void setParagraphFormat(PDLParagraphFormat paragraphFormat) {
        this.paragraphFormat = paragraphFormat;
        if (this.getLayouter() != null && this.getParagraphFormat() != null) {
            this.getLayouter().setHAlignment(this.getParagraphFormat().getHAlignment());
            this.getLayouter().setVAlignment(this.getParagraphFormat().getVAlignment());
            this.getLayouter().setMaxlines(this.getParagraphFormat().getMaxlines());
        }
    }

    @Override
    public void setTextFormat(PDLTextFormat newTextState) {
        if (newTextState == this.textFormat) {
            return;
        }
        this.textFormat = newTextState;
    }

    @Override
    public void writeOn(final ICSDevice device) {
        device.textBegin();
        ILayoutVisitor visitor = new ILayoutVisitor(){

            public Object visitFromLayoutComponent(ILayoutComponent component) {
                if (component instanceof PDLElement) {
                    ((PDLElement)component).writeOn(device);
                }
                return null;
            }

            public Object visitFromLayoutContainer(ILayoutContainer container) {
                ILayoutComponent[] children = container.children();
                for (int i = 0; i < children.length; ++i) {
                    children[i].accept((ILayoutVisitor)this);
                }
                return null;
            }
        };
        this.getLayoutContainer().accept(visitor);
        device.textEnd();
    }
}

