/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.parser;

import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.LayoutPrimitive;
import de.intarsys.pdf.layout.element.PDLElement;
import de.intarsys.pdf.layout.element.PDLFF;
import de.intarsys.pdf.layout.element.PDLLF;
import de.intarsys.pdf.layout.pad.IPDLTextPad;
import de.intarsys.pdf.layout.parser.IPDLCreationHandler;
import de.intarsys.pdf.layout.parser.PDLParseException;
import de.intarsys.pdf.layout.parser.PDLStopParse;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;

public abstract class PDLAbstractDocumentParser
implements IAttributeSupport {
    public static final int CHAR_MODE = 0;
    public static final int WORD_MODE = 1;
    public static final int LINE_MODE = 2;
    private IPDLCreationHandler creationHandler;
    private IPDLTextPad pad;
    private Map parameters;
    private char[] buffer = new char[1000];
    private boolean handlingOverflow = false;
    private List currentOverflow = null;
    private boolean newlineFound = true;
    private boolean paragraphFound = true;
    private boolean whitespaceFound = true;
    private float lineAscent = 0.0f;
    private float lineDescent = 0.0f;
    private int mode = 1;
    private int pos = 0;
    private final AttributeMap attributes = new AttributeMap();
    private boolean noLineBreak = false;
    private float fillerHeight = 0.0f;
    private int direction = 0;

    protected abstract void basicParseFragment(Reader var1) throws IOException, PDLParseException;

    public void checkOverflow() throws PDLParseException {
        List overflow = this.getActivePad().getOverflow();
        if (overflow == null) {
            return;
        }
        if (overflow.equals(this.currentOverflow)) {
            return;
        }
        if (this.getCreationHandler() != null) {
            try {
                this.setHandlingOverflow(true);
                this.currentOverflow = overflow;
                this.handleOverflow(overflow);
                this.currentOverflow = null;
            }
            finally {
                this.setHandlingOverflow(false);
            }
        }
    }

    public void close() throws PDLParseException {
        try {
            if (this.getActivePad() != null) {
                this.flush();
                IPDLTextPad tempPad = this.getActivePad();
                tempPad.close();
                this.checkOverflow();
                if (this.getActivePad() != tempPad) {
                    this.getActivePad().close();
                }
            }
        }
        catch (PDLStopParse pDLStopParse) {
            // empty catch block
        }
        if (this.getCreationHandler() != null) {
            this.getCreationHandler().handleEnd(this);
        }
    }

    public void endCurrentLine(boolean hasHeight) throws PDLParseException {
        this.flush();
        if (this.getFillerHeight() > 0.0f) {
            this.getActivePad().layoutElement((ILayoutComponent)new LayoutPrimitive(1.0f, this.getFillerHeight()));
            this.fillerHeight = 0.0f;
        }
        this.setNewlineFound(true);
        PDLLF element = new PDLLF(this.getActivePad().getTextFormat(), hasHeight);
        this.getActivePad().layoutElement(element);
        this.checkOverflow();
    }

    protected void endCurrentLineOnly(boolean hasHeight) throws PDLParseException {
        this.flush();
        if (this.getFillerHeight() > 0.0f) {
            this.getActivePad().layoutElement((ILayoutComponent)new LayoutPrimitive(1.0f, this.getFillerHeight()));
            this.fillerHeight = 0.0f;
            this.endCurrentLine(false);
        }
        this.setNewlineFound(true);
        this.checkOverflow();
    }

    public void flush() throws PDLParseException {
        if (this.getActivePad() == null) {
            return;
        }
        if (this.pos == 0) {
            return;
        }
        IPDLTextPad activePad = this.getActivePad();
        PDLElement element = activePad.createTextElement(this.buffer, 0, this.pos, this.getDirection());
        this.pos = 0;
        activePad.layoutElement(element);
        this.setCurrentAscentDescent(element.getAscent(), element.getDescent());
        this.checkOverflow();
    }

    protected abstract IPDLTextPad getActivePad();

    public final Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public IPDLCreationHandler getCreationHandler() {
        return this.creationHandler;
    }

    public int getDirection() {
        return this.direction;
    }

    public float getFillerHeight() {
        return this.fillerHeight;
    }

    public float getLineAscent() {
        return this.lineAscent;
    }

    public float getLineDescent() {
        return this.lineDescent;
    }

    public int getMode() {
        return this.mode;
    }

    public IPDLTextPad getPad() {
        return this.pad;
    }

    public Map getParameters() {
        return this.parameters;
    }

    protected void handleOverflow(List overflow) throws PDLParseException {
        IPDLTextPad previousPad = this.getActivePad();
        previousPad.close();
        boolean handled = this.getCreationHandler().handleOverflow(this, overflow);
        if (!handled) {
            throw new PDLStopParse();
        }
        this.getActivePad().getLayouter().setReplayMode(true);
        this.replayOverflow(overflow);
        this.getActivePad().getLayouter().setReplayMode(false);
        this.checkOverflow();
    }

    protected boolean isBreakAfter(char c) {
        return "-_,.;:/\\=".indexOf(c) != -1 || c == '\u00ad';
    }

    protected boolean isBreakBefore(char c) {
        return this.isWhitespace(c);
    }

    protected boolean isBreakBeforeContent(char breakAfterChar, char[] lookahead, int lookaheadRead) {
        if (lookaheadRead == 0) {
            return true;
        }
        return breakAfterChar != ',' && breakAfterChar != '.' || lookahead[0] < '0' || lookahead[0] > '9';
    }

    public boolean isCharMode() {
        return this.getMode() == 0;
    }

    protected boolean isHandlingOverflow() {
        return this.handlingOverflow;
    }

    public boolean isLineMode() {
        return this.getMode() == 2;
    }

    protected boolean isNewLine(char c) {
        return c == '\n';
    }

    protected boolean isNewlineFound() {
        return this.newlineFound;
    }

    public boolean isNoLineBreak() {
        return this.noLineBreak;
    }

    protected boolean isParagraphFound() {
        return this.paragraphFound;
    }

    protected boolean isWhitespace(char c) {
        return Character.isWhitespace(c);
    }

    protected boolean isWhitespaceFound() {
        return this.whitespaceFound;
    }

    public boolean isWordMode() {
        return this.getMode() == 1;
    }

    public void newLine(boolean forced) throws PDLParseException {
        if (forced || !this.isNewlineFound()) {
            this.endCurrentLine(true);
        }
    }

    public void newPage() throws PDLParseException {
        this.flush();
        this.resetCurrentAscentDescent();
        this.setNewlineFound(true);
        this.setParagraphFound(true);
        PDLFF element = new PDLFF(this.getActivePad().getTextFormat());
        this.getActivePad().layoutElement(element);
        this.checkOverflow();
    }

    public void newParagraph() throws PDLParseException {
        if (!this.isNewlineFound()) {
            this.endCurrentLine(true);
        }
        if (!this.isParagraphFound()) {
            this.endCurrentLine(true);
        }
        this.setParagraphFound(true);
    }

    public void parse(Reader reader) throws IOException, PDLParseException {
        this.parseFragment(reader);
        this.close();
    }

    public final void parseFragment(Reader reader) throws IOException, PDLParseException {
        this.basicParseFragment(reader);
        this.endCurrentLineOnly(false);
    }

    protected void putBuffer(char c) {
        this.buffer[this.pos++] = c;
        if (this.pos == this.buffer.length) {
            char[] temp = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, temp, 0, this.buffer.length);
            this.buffer = temp;
        }
    }

    public final Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    protected void replayOverflow(List overflow) throws PDLParseException {
        if (this.getActivePad() != null) {
            for (ILayoutComponent element : overflow) {
                this.getActivePad().layoutElement(element);
            }
        }
    }

    public void resetCurrentAscentDescent() {
        this.setLineAscent(0.0f);
        this.setLineDescent(0.0f);
    }

    public final Object setAttribute(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    public void setCreationHandler(IPDLCreationHandler overflowHandler) {
        this.creationHandler = overflowHandler;
    }

    protected void setCurrentAscentDescent(float currentLineAscent, float currentLineDescent) {
        if (this.isNewlineFound()) {
            this.setLineAscent(currentLineAscent);
            this.setLineDescent(currentLineDescent);
        } else {
            this.setLineAscent(Math.max(currentLineAscent, this.lineAscent));
            this.setLineDescent(Math.min(currentLineDescent, this.lineDescent));
        }
    }

    public void setDirection(int directionality) {
        this.direction = directionality;
    }

    public void setFillerHeight(float fillerHeight) {
        if (fillerHeight > this.getFillerHeight()) {
            this.fillerHeight = fillerHeight;
        }
    }

    protected void setHandlingOverflow(boolean handlingOverflow) {
        this.handlingOverflow = handlingOverflow;
    }

    protected void setLineAscent(float lineAscent) {
        this.lineAscent = lineAscent;
    }

    protected void setLineDescent(float lineDescent) {
        this.lineDescent = lineDescent;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    protected void setNewlineFound(boolean newlineFound) {
        this.newlineFound = newlineFound;
        if (newlineFound) {
            this.setWhitespaceFound(true);
        }
    }

    public void setNoLineBreak(boolean noLineBreak) {
        this.noLineBreak = noLineBreak;
    }

    public void setPad(IPDLTextPad pad) {
        this.pad = pad;
    }

    public void setParagraphFound(boolean flag) {
        this.paragraphFound = flag;
        if (this.paragraphFound) {
            this.setNewlineFound(true);
        }
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    protected void setWhitespaceFound(boolean whitespaceFound) {
        this.whitespaceFound = whitespaceFound;
        if (!whitespaceFound) {
            this.setNewlineFound(false);
            this.setParagraphFound(false);
        }
    }

    protected void writeLine(Reader reader) throws IOException, PDLParseException {
        int i = reader.read();
        while (i != -1) {
            char c = (char)i;
            if (this.isNewLine(c)) {
                this.flush();
                this.putBuffer(c);
                this.flush();
            } else {
                this.putBuffer(c);
            }
            i = reader.read();
        }
    }

    protected abstract void writeLineHyphenate(Reader var1) throws IOException, PDLParseException;
}

