/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.parser;

import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.layout.pad.IPDLTextPad;
import de.intarsys.pdf.layout.pad.PDLTextFormat;
import de.intarsys.pdf.layout.parser.PDLAbstractDocumentParser;
import de.intarsys.pdf.layout.parser.PDLParseException;
import de.intarsys.pdf.layout.parser.PDLStopParse;
import de.intarsys.pdf.platform.cwt.font.PlatformFontTools;
import java.io.IOException;
import java.io.Reader;
import java.text.Bidi;

public class PDLTextBidiParser
extends PDLAbstractDocumentParser {
    private char[] chars;

    @Override
    protected void basicParseFragment(Reader reader) throws IOException, PDLParseException {
        StringBuilder sb = new StringBuilder();
        while (this.parseParagraph(sb, reader)) {
            int length = sb.length();
            if (this.chars == null || this.chars.length < length) {
                this.chars = new char[length];
            }
            sb.getChars(0, length, this.chars, 0);
            this.checkTextFormatFont(this.chars, 0, length);
            Bidi bidi = new Bidi(this.chars, 0, null, 0, length, 0);
            try {
                this.layoutParagraph(this.chars, 0, length, bidi);
            }
            catch (PDLStopParse pDLStopParse) {}
        }
    }

    protected void checkTextFormatFont(char[] chars, int offset, int count) {
        PDFont font = this.getPad().getTextFormat().getFont();
        if (!font.getEncoding().isEncodable(chars, offset, count)) {
            font = PDFontTools.getType0Font((PDFont)font);
            try {
                PlatformFontTools.embedFontFile((PDFont)font);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            PDLTextFormat newFormat = this.getPad().getTextFormat().copy();
            newFormat.setFont(font);
            this.getPad().setTextFormat(newFormat);
        }
    }

    @Override
    protected IPDLTextPad getActivePad() {
        return this.getPad();
    }

    protected void layoutParagraph(char[] chars, int start, int count, Bidi bidi) throws IOException, PDLParseException {
        int index = start;
        this.setDirection(bidi.getBaseLevel());
        while (index < start + count) {
            char i = chars[index];
            char c = i;
            int level = bidi.getLevelAt(index);
            ++index;
            if (level != this.getDirection()) {
                this.flush();
                this.setDirection(level);
            }
            if (this.isNoLineBreak()) {
                this.putBuffer(c);
                continue;
            }
            if (this.isCharMode() || this.isBreakBefore(c)) {
                this.flush();
            }
            this.putBuffer(c);
            if (this.isWhitespace(c)) {
                this.flush();
                continue;
            }
            if (!this.isBreakAfter(c)) continue;
            int mark = index;
            char[] lookahead = new char[3];
            int lookaheadRead = 0;
            while (index < start + count) {
                char j = chars[index++];
                lookahead[lookaheadRead++] = j;
                if (lookaheadRead != lookahead.length) continue;
                break;
            }
            index = mark;
            if (lookaheadRead != lookahead.length || !this.isBreakBeforeContent(c, lookahead, lookaheadRead)) continue;
            this.flush();
        }
    }

    protected boolean parseParagraph(StringBuilder sb, Reader reader) throws IOException {
        int i;
        sb.setLength(0);
        while ((i = reader.read()) != -1) {
            sb.append((char)i);
            if (i != 10) continue;
            return true;
        }
        return sb.length() != 0;
    }

    @Override
    protected void writeLineHyphenate(Reader reader) throws IOException, PDLParseException {
    }
}

