/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.layout.renderer.plaintext;

import de.intarsys.layout.ILayoutComponent;
import de.intarsys.pdf.layout.element.PDLElement;
import de.intarsys.pdf.layout.pad.IPDLTextPad;
import de.intarsys.pdf.layout.parser.PDLStopParse;
import de.intarsys.pdf.layout.renderer.CommonPDLRenderer;
import de.intarsys.pdf.layout.renderer.PDLException;
import de.intarsys.tools.locator.ILocator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

public class PDLPlainTextRenderer
extends CommonPDLRenderer {
    public static final int CHAR_MODE = 0;
    public static final int LINE_MODE = 2;
    public static final int WORD_MODE = 1;
    private boolean noLineBreak = false;
    private char[] buffer = new char[1000];
    private int pos = 0;
    private int mode = 1;
    private boolean whitespaceFound = true;
    private boolean handlingOverflow = false;
    private List currentOverflow = null;
    private boolean newlineFound = true;
    private float lineAscent = 0.0f;
    private float lineDescent = 0.0f;

    public void checkOverflow() throws PDLException {
        List overflow = this.getActivePad().getOverflow();
        if (overflow == null) {
            return;
        }
        if (overflow.equals(this.currentOverflow)) {
            return;
        }
        if (this.getRenderingHandler() != null) {
            try {
                this.setHandlingOverflow(true);
                this.currentOverflow = overflow;
                this.handleOverflow(overflow);
                this.currentOverflow = null;
            }
            finally {
                this.setHandlingOverflow(false);
            }
        }
    }

    protected void close() throws PDLException {
        if (this.getRenderingHandler() != null) {
            this.getRenderingHandler().handleEnd(this);
        }
    }

    public void flush() throws PDLException {
        if (this.pos == 0) {
            return;
        }
        IPDLTextPad activePad = this.getActivePad();
        PDLElement element = activePad.createTextElement(this.buffer, 0, this.pos, 0);
        this.pos = 0;
        activePad.layoutElement(element);
        this.setCurrentAscentDescent(element.getAscent(), element.getDescent());
        this.checkOverflow();
    }

    protected IPDLTextPad getActivePad() {
        return null;
    }

    public float getLineAscent() {
        return this.lineAscent;
    }

    public float getLineDescent() {
        return this.lineDescent;
    }

    public int getMode() {
        return this.mode;
    }

    protected void handleOverflow(List overflow) throws PDLException {
        IPDLTextPad previousPad = this.getActivePad();
        previousPad.close();
        boolean handled = this.getRenderingHandler().handleOverflow(this, overflow);
        if (!handled) {
            throw new PDLStopParse();
        }
        this.getActivePad().getLayouter().setReplayMode(true);
        this.replayOverflow(overflow);
        this.getActivePad().getLayouter().setReplayMode(false);
        this.checkOverflow();
    }

    protected boolean isBreakAfter(char c) {
        return "-_,.;:/\\=".indexOf(c) != -1 || c == '\u00ad';
    }

    protected boolean isBreakBefore(char c) {
        return this.isWhitespace(c);
    }

    protected boolean isBreakBeforeContent(char breakAfterChar, char[] lookahead, int lookaheadRead) {
        if (lookaheadRead == 0) {
            return true;
        }
        return breakAfterChar != ',' && breakAfterChar != '.' || lookahead[0] < '0' || lookahead[0] > '9';
    }

    public boolean isCharMode() {
        return this.getMode() == 0;
    }

    protected boolean isHandlingOverflow() {
        return this.handlingOverflow;
    }

    public boolean isLineMode() {
        return this.getMode() == 2;
    }

    protected boolean isNewlineFound() {
        return this.newlineFound;
    }

    public boolean isNoLineBreak() {
        return this.noLineBreak;
    }

    protected boolean isWhitespace(char c) {
        return Character.isWhitespace(c);
    }

    protected boolean isWhitespaceFound() {
        return this.whitespaceFound;
    }

    @Override
    public void process(ILocator locator) throws IOException {
        Reader reader = locator.getReader();
        try {
            this.writeLineHyphenate(reader);
        }
        catch (PDLStopParse pDLStopParse) {
            // empty catch block
        }
        this.close();
    }

    protected void putBuffer(char c) {
        this.buffer[this.pos++] = c;
        if (this.pos == this.buffer.length) {
            char[] temp = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, temp, 0, this.buffer.length);
            this.buffer = temp;
        }
    }

    protected void replayOverflow(List overflow) throws PDLException {
        if (this.getActivePad() != null) {
            for (ILayoutComponent element : overflow) {
                this.getActivePad().layoutElement(element);
            }
        }
    }

    protected void setCurrentAscentDescent(float currentLineAscent, float currentLineDescent) {
        if (this.isNewlineFound()) {
            this.setLineAscent(currentLineAscent);
            this.setLineDescent(currentLineDescent);
        } else {
            this.setLineAscent(Math.max(currentLineAscent, this.lineAscent));
            this.setLineDescent(Math.min(currentLineDescent, this.lineDescent));
        }
    }

    protected void setHandlingOverflow(boolean handlingOverflow) {
        this.handlingOverflow = handlingOverflow;
    }

    protected void setLineAscent(float lineAscent) {
        this.lineAscent = lineAscent;
    }

    protected void setLineDescent(float lineDescent) {
        this.lineDescent = lineDescent;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setNoLineBreak(boolean noLineBreak) {
        this.noLineBreak = noLineBreak;
    }

    protected void writeLineHyphenate(Reader reader) throws IOException, PDLException {
        BufferedReader bReader = new BufferedReader(reader, 10);
        int i = bReader.read();
        while (i != -1) {
            char c = (char)i;
            if (this.isNoLineBreak()) {
                this.putBuffer(c);
            } else {
                if (this.isCharMode() || this.isBreakBefore(c)) {
                    this.flush();
                }
                this.putBuffer(c);
                if (this.isWhitespace(c)) {
                    this.flush();
                } else if (this.isBreakAfter(c)) {
                    int j;
                    bReader.mark(3);
                    char[] lookahead = new char[3];
                    int lookaheadRead = 0;
                    do {
                        j = bReader.read();
                        lookahead[lookaheadRead++] = (char)j;
                    } while (j != -1 && lookaheadRead != lookahead.length);
                    bReader.reset();
                    if (this.isBreakBeforeContent(c, lookahead, lookaheadRead)) {
                        this.flush();
                    }
                }
            }
            i = bReader.read();
        }
    }
}

