/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography.implementation;

import com.azure.core.util.Context;
import com.azure.security.keyvault.keys.cryptography.implementation.Algorithm;
import com.azure.security.keyvault.keys.cryptography.implementation.AlgorithmResolver;
import com.azure.security.keyvault.keys.cryptography.implementation.AsymmetricSignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.implementation.CryptographyClientImpl;
import com.azure.security.keyvault.keys.cryptography.implementation.CryptographyUtils;
import com.azure.security.keyvault.keys.cryptography.implementation.Ecdsa;
import com.azure.security.keyvault.keys.cryptography.implementation.HashAlgorithm;
import com.azure.security.keyvault.keys.cryptography.implementation.ISignatureTransform;
import com.azure.security.keyvault.keys.cryptography.implementation.LocalKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.implementation.SignatureHashResolver;
import com.azure.security.keyvault.keys.cryptography.models.DecryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyOperation;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Objects;
import reactor.core.publisher.Mono;

class EcKeyCryptographyClient
extends LocalKeyCryptographyClient {
    private final KeyPair ecKeyPair;
    private final Provider provider = Security.getProvider("BC");

    EcKeyCryptographyClient(JsonWebKey jsonWebKey, CryptographyClientImpl implClient) {
        super(jsonWebKey, implClient);
        this.ecKeyPair = jsonWebKey.toEc(jsonWebKey.hasPrivateKey(), this.provider);
    }

    @Override
    public Mono<EncryptResult> encryptAsync(EncryptionAlgorithm algorithm, byte[] plaintext, Context context) {
        throw new UnsupportedOperationException("The encrypt operation is not supported for EC keys.");
    }

    @Override
    public EncryptResult encrypt(EncryptionAlgorithm algorithm, byte[] plaintext, Context context) {
        throw new UnsupportedOperationException("The encrypt operation is not supported for EC keys.");
    }

    @Override
    public Mono<EncryptResult> encryptAsync(EncryptParameters options, Context context) {
        throw new UnsupportedOperationException("The encrypt operation is not supported for EC keys.");
    }

    @Override
    public EncryptResult encrypt(EncryptParameters options, Context context) {
        throw new UnsupportedOperationException("The encrypt operation is not supported for EC keys.");
    }

    @Override
    public Mono<DecryptResult> decryptAsync(EncryptionAlgorithm algorithm, byte[] plaintext, Context context) {
        throw new UnsupportedOperationException("The decrypt operation is not supported for EC keys.");
    }

    @Override
    public DecryptResult decrypt(EncryptionAlgorithm algorithm, byte[] plaintext, Context context) {
        throw new UnsupportedOperationException("The decrypt operation is not supported for EC keys.");
    }

    @Override
    public Mono<DecryptResult> decryptAsync(DecryptParameters options, Context context) {
        throw new UnsupportedOperationException("The decrypt operation is not supported for EC keys.");
    }

    @Override
    public DecryptResult decrypt(DecryptParameters options, Context context) {
        throw new UnsupportedOperationException("The decrypt operation is not supported for EC keys.");
    }

    @Override
    public Mono<SignResult> signAsync(SignatureAlgorithm algorithm, byte[] digest, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.implClient != null) {
                return this.implClient.signAsync(algorithm, digest, context);
            }
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricSignatureAlgorithm)) {
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.ecKeyPair.getPrivate() == null) {
            if (this.implClient != null) {
                return this.implClient.signAsync(algorithm, digest, context);
            }
            throw new IllegalArgumentException("The private portion of the key is not locally available to perform the sign operation.");
        }
        CryptographyUtils.verifyKeyPermissions(this.jsonWebKey, KeyOperation.SIGN);
        if (!(baseAlgorithm instanceof Ecdsa)) {
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        Ecdsa algo = (Ecdsa)baseAlgorithm;
        ISignatureTransform signer = algo.createSignatureTransform(this.ecKeyPair, this.provider);
        return Mono.fromCallable(() -> new SignResult(signer.sign(digest), algorithm, this.jsonWebKey.getId()));
    }

    @Override
    public SignResult sign(SignatureAlgorithm algorithm, byte[] digest, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.implClient != null) {
                return this.implClient.sign(algorithm, digest, context);
            }
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricSignatureAlgorithm)) {
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.ecKeyPair.getPrivate() == null) {
            if (this.implClient != null) {
                return this.implClient.sign(algorithm, digest, context);
            }
            throw new IllegalArgumentException("The private portion of the key is not locally available to perform the sign operation.");
        }
        CryptographyUtils.verifyKeyPermissions(this.jsonWebKey, KeyOperation.SIGN);
        if (!(baseAlgorithm instanceof Ecdsa)) {
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        Ecdsa algo = (Ecdsa)baseAlgorithm;
        ISignatureTransform signer = algo.createSignatureTransform(this.ecKeyPair, this.provider);
        try {
            return new SignResult(signer.sign(digest), algorithm, this.jsonWebKey.getId());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public Mono<VerifyResult> verifyAsync(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        Objects.requireNonNull(signature, "Signature to be verified cannot be null.");
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.implClient != null) {
                return this.implClient.verifyAsync(algorithm, digest, signature, context);
            }
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricSignatureAlgorithm)) {
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.ecKeyPair.getPublic() == null) {
            if (this.implClient != null) {
                return this.implClient.verifyAsync(algorithm, digest, signature, context);
            }
            throw new IllegalArgumentException("The public portion of the key is not locally available to perform the verify operation.");
        }
        CryptographyUtils.verifyKeyPermissions(this.jsonWebKey, KeyOperation.VERIFY);
        if (!(baseAlgorithm instanceof Ecdsa)) {
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        Ecdsa algo = (Ecdsa)baseAlgorithm;
        ISignatureTransform signer = algo.createSignatureTransform(this.ecKeyPair, this.provider);
        return Mono.fromCallable(() -> new VerifyResult(signer.verify(digest, signature), algorithm, this.jsonWebKey.getId()));
    }

    @Override
    public VerifyResult verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        Objects.requireNonNull(signature, "Signature to be verified cannot be null.");
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.implClient != null) {
                return this.implClient.verify(algorithm, digest, signature, context);
            }
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricSignatureAlgorithm)) {
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.ecKeyPair.getPublic() == null) {
            if (this.implClient != null) {
                return this.implClient.verify(algorithm, digest, signature, context);
            }
            throw new IllegalArgumentException("The public portion of the key is not locally available to perform the verify operation.");
        }
        CryptographyUtils.verifyKeyPermissions(this.jsonWebKey, KeyOperation.VERIFY);
        if (!(baseAlgorithm instanceof Ecdsa)) {
            throw new RuntimeException(new NoSuchAlgorithmException(algorithm.toString()));
        }
        Ecdsa algo = (Ecdsa)baseAlgorithm;
        ISignatureTransform signer = algo.createSignatureTransform(this.ecKeyPair, this.provider);
        try {
            return new VerifyResult(signer.verify(digest, signature), algorithm, this.jsonWebKey.getId());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public Mono<WrapResult> wrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] keyToWrap, Context context) {
        throw new UnsupportedOperationException("The key wrap operation is not supported for EC keys.");
    }

    @Override
    public WrapResult wrapKey(KeyWrapAlgorithm algorithm, byte[] keyToWrap, Context context) {
        throw new UnsupportedOperationException("The key wrap operation is not supported for EC keys.");
    }

    @Override
    public Mono<UnwrapResult> unwrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] encryptedKey, Context context) {
        throw new UnsupportedOperationException("The key unwrap operation is not supported for EC keys.");
    }

    @Override
    public UnwrapResult unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey, Context context) {
        throw new UnsupportedOperationException("The key unwrap operation is not supported for EC keys.");
    }

    @Override
    public Mono<SignResult> signDataAsync(SignatureAlgorithm algorithm, byte[] data, Context context) {
        try {
            return this.signAsync(algorithm, EcKeyCryptographyClient.calculateDigest(algorithm, data), context);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SignResult signData(SignatureAlgorithm algorithm, byte[] data, Context context) {
        try {
            return this.sign(algorithm, EcKeyCryptographyClient.calculateDigest(algorithm, data), context);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Mono<VerifyResult> verifyDataAsync(SignatureAlgorithm algorithm, byte[] data, byte[] signature, Context context) {
        try {
            return this.verifyAsync(algorithm, EcKeyCryptographyClient.calculateDigest(algorithm, data), signature, context);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public VerifyResult verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature, Context context) {
        try {
            return this.verify(algorithm, EcKeyCryptographyClient.calculateDigest(algorithm, data), signature, context);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] calculateDigest(SignatureAlgorithm algorithm, byte[] data) throws NoSuchAlgorithmException {
        HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
        MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
        md.update(data);
        return md.digest();
    }
}

