/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.implementation.KeyVaultKeysUtils;
import com.azure.security.keyvault.keys.models.KeyCurveName;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class JsonWebKey
implements JsonSerializable<JsonWebKey> {
    private static final ClientLogger LOGGER = new ClientLogger(JsonWebKey.class);
    private String keyId;
    private KeyType keyType;
    private List<KeyOperation> keyOps;
    private byte[] n;
    private byte[] e;
    private byte[] d;
    private byte[] dp;
    private byte[] dq;
    private byte[] qi;
    private byte[] p;
    private byte[] q;
    private byte[] k;
    private byte[] t;
    private KeyCurveName crv;
    private byte[] x;
    private byte[] y;
    private static final List<KeyCurveName> KNOWN_CURVE_NAMES = Arrays.asList(KeyCurveName.P_256, KeyCurveName.P_384, KeyCurveName.P_521, KeyCurveName.P_256K);

    public String getId() {
        return this.keyId;
    }

    public JsonWebKey setId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public JsonWebKey setKeyType(KeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    public List<KeyOperation> getKeyOps() {
        return this.keyOps == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(this.keyOps);
    }

    public JsonWebKey setKeyOps(List<KeyOperation> keyOps) {
        this.keyOps = keyOps;
        return this;
    }

    public byte[] getN() {
        return CoreUtils.clone((byte[])this.n);
    }

    public JsonWebKey setN(byte[] n) {
        this.n = CoreUtils.clone((byte[])n);
        return this;
    }

    public byte[] getE() {
        return CoreUtils.clone((byte[])this.e);
    }

    public JsonWebKey setE(byte[] e) {
        this.e = CoreUtils.clone((byte[])e);
        return this;
    }

    public byte[] getD() {
        return CoreUtils.clone((byte[])this.d);
    }

    public JsonWebKey setD(byte[] d) {
        this.d = CoreUtils.clone((byte[])d);
        return this;
    }

    public byte[] getDp() {
        return CoreUtils.clone((byte[])this.dp);
    }

    public JsonWebKey setDp(byte[] dp) {
        this.dp = CoreUtils.clone((byte[])dp);
        return this;
    }

    public byte[] getDq() {
        return CoreUtils.clone((byte[])this.dq);
    }

    public JsonWebKey setDq(byte[] dq) {
        this.dq = CoreUtils.clone((byte[])dq);
        return this;
    }

    public byte[] getQi() {
        return CoreUtils.clone((byte[])this.qi);
    }

    public JsonWebKey setQi(byte[] qi) {
        this.qi = CoreUtils.clone((byte[])qi);
        return this;
    }

    public byte[] getP() {
        return CoreUtils.clone((byte[])this.p);
    }

    public JsonWebKey setP(byte[] p) {
        this.p = CoreUtils.clone((byte[])p);
        return this;
    }

    public byte[] getQ() {
        return CoreUtils.clone((byte[])this.q);
    }

    public JsonWebKey setQ(byte[] q) {
        this.q = CoreUtils.clone((byte[])q);
        return this;
    }

    public byte[] getK() {
        return CoreUtils.clone((byte[])this.k);
    }

    public JsonWebKey setK(byte[] k) {
        this.k = CoreUtils.clone((byte[])k);
        return this;
    }

    public byte[] getT() {
        return CoreUtils.clone((byte[])this.t);
    }

    public JsonWebKey setT(byte[] t) {
        this.t = CoreUtils.clone((byte[])t);
        return this;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String string;
            block13: {
                JsonWriter writer = JsonProviders.createWriter((OutputStream)baos);
                try {
                    this.toJson(writer).flush();
                    string = baos.toString(StandardCharsets.UTF_8.name());
                    if (writer == null) break block13;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return string;
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
    }

    public KeyCurveName getCurveName() {
        return this.crv;
    }

    public JsonWebKey setCurveName(KeyCurveName crv) {
        this.crv = crv;
        return this;
    }

    public byte[] getX() {
        return CoreUtils.clone((byte[])this.x);
    }

    public JsonWebKey setX(byte[] x) {
        this.x = CoreUtils.clone((byte[])x);
        return this;
    }

    public byte[] getY() {
        return CoreUtils.clone((byte[])this.y);
    }

    public JsonWebKey setY(byte[] y) {
        this.y = CoreUtils.clone((byte[])y);
        return this;
    }

    private RSAPublicKeySpec getRsaPublicKeySpec() {
        return new RSAPublicKeySpec(JsonWebKey.toBigInteger(this.n), JsonWebKey.toBigInteger(this.e));
    }

    private RSAPrivateKeySpec getRsaPrivateKeySpec() {
        return new RSAPrivateCrtKeySpec(JsonWebKey.toBigInteger(this.n), JsonWebKey.toBigInteger(this.e), JsonWebKey.toBigInteger(this.d), JsonWebKey.toBigInteger(this.p), JsonWebKey.toBigInteger(this.q), JsonWebKey.toBigInteger(this.dp), JsonWebKey.toBigInteger(this.dq), JsonWebKey.toBigInteger(this.qi));
    }

    private PublicKey getRsaPublicKey(Provider provider) {
        try {
            RSAPublicKeySpec publicKeySpec = this.getRsaPublicKeySpec();
            KeyFactory factory = provider != null ? KeyFactory.getInstance("RSA", provider) : KeyFactory.getInstance("RSA");
            return factory.generatePublic(publicKeySpec);
        }
        catch (GeneralSecurityException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
    }

    private PrivateKey getRsaPrivateKey(Provider provider) {
        try {
            RSAPrivateKeySpec privateKeySpec = this.getRsaPrivateKeySpec();
            KeyFactory factory = provider != null ? KeyFactory.getInstance("RSA", provider) : KeyFactory.getInstance("RSA");
            return factory.generatePrivate(privateKeySpec);
        }
        catch (GeneralSecurityException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
    }

    private static PublicKey getEcPublicKey(ECPoint ecPoint, ECParameterSpec curveSpec, Provider provider) {
        try {
            ECPublicKeySpec pubSpec = new ECPublicKeySpec(ecPoint, curveSpec);
            KeyFactory kf = provider != null ? KeyFactory.getInstance("EC", provider) : KeyFactory.getInstance("EC", "BC");
            return (ECPublicKey)kf.generatePublic(pubSpec);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private static PrivateKey getEcPrivateKey(byte[] d, ECParameterSpec curveSpec, Provider provider) {
        try {
            ECPrivateKeySpec priSpec = new ECPrivateKeySpec(new BigInteger(1, d), curveSpec);
            KeyFactory kf = provider != null ? KeyFactory.getInstance("EC", provider) : KeyFactory.getInstance("EC", "BC");
            return (ECPrivateKey)kf.generatePrivate(priSpec);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private void checkRsaCompatible() {
        if (!KeyType.RSA.equals((Object)this.keyType) && !KeyType.RSA_HSM.equals((Object)this.keyType)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Not an RSA key"));
        }
    }

    private static byte[] toByteArray(BigInteger n) {
        byte[] result = n.toByteArray();
        if (result[0] == 0) {
            return Arrays.copyOfRange(result, 1, result.length);
        }
        return result;
    }

    private static BigInteger toBigInteger(byte[] b) {
        if (b[0] < 0) {
            byte[] temp = new byte[1 + b.length];
            System.arraycopy(b, 0, temp, 1, b.length);
            b = temp;
        }
        return new BigInteger(b);
    }

    public static JsonWebKey fromRsa(KeyPair keyPair) {
        RSAPrivateCrtKey privateKey = (RSAPrivateCrtKey)keyPair.getPrivate();
        JsonWebKey key = null;
        if (privateKey != null) {
            key = new JsonWebKey().setKeyType(KeyType.RSA).setN(JsonWebKey.toByteArray(privateKey.getModulus())).setE(JsonWebKey.toByteArray(privateKey.getPublicExponent())).setD(JsonWebKey.toByteArray(privateKey.getPrivateExponent())).setP(JsonWebKey.toByteArray(privateKey.getPrimeP())).setQ(JsonWebKey.toByteArray(privateKey.getPrimeQ())).setDp(JsonWebKey.toByteArray(privateKey.getPrimeExponentP())).setDq(JsonWebKey.toByteArray(privateKey.getPrimeExponentQ())).setQi(JsonWebKey.toByteArray(privateKey.getCrtCoefficient()));
        } else {
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            key = new JsonWebKey().setKeyType(KeyType.RSA).setN(JsonWebKey.toByteArray(publicKey.getModulus())).setE(JsonWebKey.toByteArray(publicKey.getPublicExponent())).setD(null).setP(null).setQ(null).setDp(null).setDq(null).setQi(null);
        }
        return key;
    }

    public static JsonWebKey fromRsa(KeyPair keyPair, List<KeyOperation> keyOperations) {
        return JsonWebKey.fromRsa(keyPair).setKeyOps(keyOperations);
    }

    public KeyPair toRsa() {
        return this.toRsa(false);
    }

    public KeyPair toRsa(boolean includePrivateParameters) {
        return this.toRsa(includePrivateParameters, null);
    }

    public KeyPair toRsa(boolean includePrivateParameters, Provider provider) {
        this.checkRsaCompatible();
        if (includePrivateParameters) {
            return new KeyPair(this.getRsaPublicKey(provider), this.getRsaPrivateKey(provider));
        }
        return new KeyPair(this.getRsaPublicKey(provider), null);
    }

    public KeyPair toEc() {
        return this.toEc(false, null);
    }

    public KeyPair toEc(boolean includePrivateParameters) {
        return this.toEc(includePrivateParameters, null);
    }

    public KeyPair toEc(boolean includePrivateParameters, Provider provider) {
        if (!KeyType.EC.equals((Object)this.keyType) && !KeyType.EC_HSM.equals((Object)this.keyType)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Not an EC key."));
        }
        if (provider == null) {
            provider = Security.getProvider("BC");
        }
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", provider);
            ECGenParameterSpec gps = new ECGenParameterSpec(JsonWebKey.getCurveSpecName(this.crv));
            kpg.initialize(gps);
            KeyPair keyPair = kpg.generateKeyPair();
            ECPublicKey publicKey = (ECPublicKey)keyPair.getPublic();
            ECParameterSpec ecParameterSpec = publicKey.getParams();
            ECPoint ecPoint = new ECPoint(new BigInteger(1, this.x), new BigInteger(1, this.y));
            KeyPair realKeyPair = includePrivateParameters ? new KeyPair(JsonWebKey.getEcPublicKey(ecPoint, ecParameterSpec, provider), JsonWebKey.getEcPrivateKey(this.d, ecParameterSpec, provider)) : new KeyPair(JsonWebKey.getEcPublicKey(ecPoint, ecParameterSpec, provider), null);
            return realKeyPair;
        }
        catch (GeneralSecurityException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
    }

    public static JsonWebKey fromEc(KeyPair keyPair, Provider provider) {
        ECPublicKey publicKey = (ECPublicKey)keyPair.getPublic();
        JsonWebKey jsonWebKey = new JsonWebKey().setKeyType(KeyType.EC).setCurveName(JsonWebKey.getCurveFromKeyPair(keyPair, provider)).setX(publicKey.getW().getAffineX().toByteArray()).setY(publicKey.getW().getAffineY().toByteArray()).setKeyType(KeyType.EC);
        ECPrivateKey ecPrivateKey = (ECPrivateKey)keyPair.getPrivate();
        if (ecPrivateKey != null) {
            jsonWebKey.setD(ecPrivateKey.getS().toByteArray());
        }
        return jsonWebKey;
    }

    public static JsonWebKey fromEc(KeyPair keyPair, Provider provider, List<KeyOperation> keyOperations) {
        return JsonWebKey.fromEc(keyPair, provider).setKeyOps(keyOperations);
    }

    private static KeyCurveName getCurveFromKeyPair(KeyPair keyPair, Provider provider) {
        try {
            ECPublicKey key = (ECPublicKey)keyPair.getPublic();
            ECParameterSpec spec = key.getParams();
            EllipticCurve crv = spec.getCurve();
            for (KeyCurveName curve : KNOWN_CURVE_NAMES) {
                ECGenParameterSpec gps = new ECGenParameterSpec(JsonWebKey.getCurveSpecName(curve));
                KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", provider);
                kpg.initialize(gps);
                KeyPair apair = kpg.generateKeyPair();
                ECPublicKey apub = (ECPublicKey)apair.getPublic();
                ECParameterSpec aspec = apub.getParams();
                EllipticCurve acurve = aspec.getCurve();
                if (!acurve.equals(crv)) continue;
                return curve;
            }
            throw new NoSuchAlgorithmException("Curve not supported.");
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static JsonWebKey fromAes(SecretKey secretKey) {
        if (secretKey == null) {
            return null;
        }
        return new JsonWebKey().setK(secretKey.getEncoded()).setKeyType(KeyType.OCT);
    }

    public static JsonWebKey fromAes(SecretKey secretKey, List<KeyOperation> keyOperations) {
        return JsonWebKey.fromAes(secretKey).setKeyOps(keyOperations);
    }

    public SecretKey toAes() {
        if (this.k == null) {
            return null;
        }
        return new SecretKeySpec(this.k, "AES");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JsonWebKey) {
            return this.equals((JsonWebKey)obj);
        }
        return false;
    }

    public boolean equals(JsonWebKey jwk) {
        if (jwk == null) {
            return false;
        }
        return Objects.equals(this.keyId, jwk.keyId) && Objects.equals((Object)this.keyType, (Object)jwk.keyType) && Objects.equals(this.keyOps, jwk.keyOps) && Objects.equals((Object)this.crv, (Object)jwk.crv) && Arrays.equals(this.k, jwk.k) && Arrays.equals(this.n, jwk.n) && Arrays.equals(this.e, jwk.e) && Arrays.equals(this.d, jwk.d) && Arrays.equals(this.dp, jwk.dp) && Arrays.equals(this.dq, jwk.dq) && Arrays.equals(this.qi, jwk.qi) && Arrays.equals(this.p, jwk.p) && Arrays.equals(this.q, jwk.q) && Arrays.equals(this.x, jwk.x) && Arrays.equals(this.y, jwk.y) && Arrays.equals(this.t, jwk.t);
    }

    public boolean hasPrivateKey() {
        if (KeyType.OCT.equals((Object)this.keyType)) {
            return this.k != null;
        }
        if (KeyType.RSA.equals((Object)this.keyType) || KeyType.RSA_HSM.equals((Object)this.keyType)) {
            return this.d != null && this.dp != null && this.dq != null && this.qi != null && this.p != null && this.q != null;
        }
        if (KeyType.EC.equals((Object)this.keyType) || KeyType.EC_HSM.equals((Object)this.keyType)) {
            return this.d != null;
        }
        return false;
    }

    public boolean isValid() {
        if (this.keyType == null) {
            return false;
        }
        if (KeyType.OCT.equals((Object)this.keyType) || KeyType.OCT_HSM.equals((Object)this.keyType)) {
            return this.isValidOctet();
        }
        if (KeyType.RSA.equals((Object)this.keyType)) {
            return this.isValidRsa();
        }
        if (KeyType.RSA_HSM.equals((Object)this.keyType)) {
            return this.isValidRsaHsm();
        }
        if (KeyType.EC.equals((Object)this.keyType)) {
            return this.isValidEc();
        }
        if (KeyType.EC_HSM.equals((Object)this.keyType)) {
            return this.isValidEcHsm();
        }
        return false;
    }

    private boolean isValidOctet() {
        return this.k != null;
    }

    private boolean isValidRsa() {
        if (this.n == null || this.e == null) {
            return false;
        }
        return this.hasPrivateKey() || this.d == null && this.dp == null && this.dq == null && this.qi == null && this.p == null && this.q == null;
    }

    private boolean isValidRsaHsm() {
        boolean publicParameters;
        if (this.n == null && this.e != null || this.n != null && this.e == null) {
            return false;
        }
        if (this.hasPrivateKey()) {
            return false;
        }
        boolean tokenParameters = this.t != null;
        boolean bl = publicParameters = this.n != null && this.e != null;
        if (tokenParameters && publicParameters) {
            return false;
        }
        return tokenParameters || publicParameters;
    }

    private boolean isValidEc() {
        boolean ecPointParameters;
        boolean bl = ecPointParameters = this.x != null && this.y != null;
        if (!ecPointParameters || this.crv == null) {
            return false;
        }
        return this.hasPrivateKey() || this.d == null;
    }

    private boolean isValidEcHsm() {
        boolean tokenParameters;
        boolean ecPointParameters;
        boolean bl = ecPointParameters = this.x != null && this.y != null;
        if (ecPointParameters && this.crv == null || !ecPointParameters && this.crv != null) {
            return false;
        }
        if (this.hasPrivateKey()) {
            return false;
        }
        boolean publicParameters = ecPointParameters && this.crv != null;
        boolean bl2 = tokenParameters = this.t != null;
        if (tokenParameters && publicParameters) {
            return false;
        }
        return tokenParameters || publicParameters;
    }

    public void clearMemory() {
        JsonWebKey.zeroArray(this.k);
        this.k = null;
        JsonWebKey.zeroArray(this.n);
        this.n = null;
        JsonWebKey.zeroArray(this.e);
        this.e = null;
        JsonWebKey.zeroArray(this.d);
        this.d = null;
        JsonWebKey.zeroArray(this.dp);
        this.dp = null;
        JsonWebKey.zeroArray(this.dq);
        this.dq = null;
        JsonWebKey.zeroArray(this.qi);
        this.qi = null;
        JsonWebKey.zeroArray(this.p);
        this.p = null;
        JsonWebKey.zeroArray(this.q);
        this.q = null;
        JsonWebKey.zeroArray(this.t);
        this.t = null;
        JsonWebKey.zeroArray(this.x);
        this.x = null;
        JsonWebKey.zeroArray(this.y);
        this.y = null;
    }

    private static void zeroArray(byte[] bytes) {
        if (bytes != null) {
            Arrays.fill(bytes, (byte)0);
        }
    }

    public int hashCode() {
        int hashCode = 48313;
        if (this.keyId != null) {
            hashCode += this.keyId.hashCode();
        }
        if (KeyType.OCT.equals((Object)this.keyType)) {
            hashCode += JsonWebKey.hashCode(this.k);
        } else if (KeyType.RSA.equals((Object)this.keyType)) {
            hashCode += JsonWebKey.hashCode(this.n);
        } else if (KeyType.EC.equals((Object)this.keyType)) {
            hashCode += JsonWebKey.hashCode(this.x);
            hashCode += JsonWebKey.hashCode(this.y);
            hashCode += this.crv.hashCode();
        } else if (KeyType.RSA_HSM.equals((Object)this.keyType) || KeyType.EC_HSM.equals((Object)this.keyType)) {
            hashCode += JsonWebKey.hashCode(this.t);
        }
        return hashCode;
    }

    private static int hashCode(byte[] obj) {
        int hashCode = 0;
        if (obj == null || obj.length == 0) {
            return 0;
        }
        for (byte b : obj) {
            hashCode = hashCode << 3 | hashCode >> 29 ^ b;
        }
        return hashCode;
    }

    private static String getCurveSpecName(KeyCurveName curveName) {
        if (curveName == null) {
            return null;
        }
        if (curveName == KeyCurveName.P_256) {
            return "secp256r1";
        }
        if (curveName == KeyCurveName.P_384) {
            return "secp384r1";
        }
        if (curveName == KeyCurveName.P_521) {
            return "secp521r1";
        }
        if (curveName == KeyCurveName.P_256K) {
            return "secp256k1";
        }
        return null;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kid", this.keyId);
        jsonWriter.writeStringField("kty", Objects.toString((Object)this.keyType, null));
        jsonWriter.writeArrayField("key_ops", this.keyOps, (writer, op) -> writer.writeString(Objects.toString(op, null)));
        jsonWriter.writeStringField("n", KeyVaultKeysUtils.base64UrlJsonSerialization(this.n));
        jsonWriter.writeStringField("e", KeyVaultKeysUtils.base64UrlJsonSerialization(this.e));
        jsonWriter.writeStringField("d", KeyVaultKeysUtils.base64UrlJsonSerialization(this.d));
        jsonWriter.writeStringField("dp", KeyVaultKeysUtils.base64UrlJsonSerialization(this.dp));
        jsonWriter.writeStringField("dq", KeyVaultKeysUtils.base64UrlJsonSerialization(this.dq));
        jsonWriter.writeStringField("qi", KeyVaultKeysUtils.base64UrlJsonSerialization(this.qi));
        jsonWriter.writeStringField("p", KeyVaultKeysUtils.base64UrlJsonSerialization(this.p));
        jsonWriter.writeStringField("q", KeyVaultKeysUtils.base64UrlJsonSerialization(this.q));
        jsonWriter.writeStringField("k", KeyVaultKeysUtils.base64UrlJsonSerialization(this.k));
        jsonWriter.writeStringField("key_hsm", KeyVaultKeysUtils.base64UrlJsonSerialization(this.t));
        jsonWriter.writeStringField("crv", Objects.toString((Object)this.crv, null));
        jsonWriter.writeStringField("x", KeyVaultKeysUtils.base64UrlJsonSerialization(this.x));
        jsonWriter.writeStringField("y", KeyVaultKeysUtils.base64UrlJsonSerialization(this.y));
        return jsonWriter.writeEndObject();
    }

    public static JsonWebKey fromJson(JsonReader jsonReader) throws IOException {
        return (JsonWebKey)jsonReader.readObject(reader -> {
            JsonWebKey key = new JsonWebKey();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kid".equals(fieldName)) {
                    key.keyId = reader.getString();
                    continue;
                }
                if ("kty".equals(fieldName)) {
                    key.keyType = KeyType.fromString(reader.getString());
                    continue;
                }
                if ("key_ops".equals(fieldName)) {
                    key.keyOps = reader.readArray(arrayReader -> KeyOperation.fromString(arrayReader.getString()));
                    continue;
                }
                if ("n".equals(fieldName)) {
                    key.n = KeyVaultKeysUtils.base64UrlJsonDeserialization(reader.getString());
                    continue;
                }
                if ("e".equals(fieldName)) {
                    key.e = KeyVaultKeysUtils.base64UrlJsonDeserialization(reader.getString());
                    continue;
                }
                if ("d".equals(fieldName)) {
                    key.d = KeyVaultKeysUtils.base64UrlJsonDeserialization(reader.getString());
                    continue;
                }
                if ("dp".equals(fieldName)) {
                    key.dp = KeyVaultKeysUtils.base64UrlJsonDeserialization(reader.getString());
                    continue;
                }
                if ("dq".equals(fieldName)) {
                    key.dq = KeyVaultKeysUtils.base64UrlJsonDeserialization(reader.getString());
                    continue;
                }
                if ("qi".equals(fieldName)) {
                    key.qi = KeyVaultKeysUtils.base64UrlJsonDeserialization(reader.getString());
                    continue;
                }
                if ("p".equals(fieldName)) {
                    key.p = KeyVaultKeysUtils.base64UrlJsonDeserialization(reader.getString());
                    continue;
                }
                if ("q".equals(fieldName)) {
                    key.q = KeyVaultKeysUtils.base64UrlJsonDeserialization(reader.getString());
                    continue;
                }
                if ("k".equals(fieldName)) {
                    key.k = KeyVaultKeysUtils.base64UrlJsonDeserialization(reader.getString());
                    continue;
                }
                if ("key_hsm".equals(fieldName)) {
                    key.t = KeyVaultKeysUtils.base64UrlJsonDeserialization(reader.getString());
                    continue;
                }
                if ("crv".equals(fieldName)) {
                    key.crv = KeyCurveName.fromString(reader.getString());
                    continue;
                }
                if ("x".equals(fieldName)) {
                    key.x = KeyVaultKeysUtils.base64UrlJsonDeserialization(reader.getString());
                    continue;
                }
                if ("y".equals(fieldName)) {
                    key.y = KeyVaultKeysUtils.base64UrlJsonDeserialization(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return key;
        });
    }
}

