/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.gears.app.signature;

import de.intarsys.cloudsuite.gears.core.client.ConversationStub;
import de.intarsys.cloudsuite.gears.core.client.GearsServiceException;
import de.intarsys.cloudsuite.gears.core.conversation.ConversationStubConversationAdapter;
import de.intarsys.cloudsuite.gears.core.service.common.api.FlowOptions;
import de.intarsys.cloudsuite.gears.core.service.common.api.IOptionSupport;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.signer.api.RequestSignerCreate;
import de.intarsys.cloudsuite.gears.core.service.signer.api.ResultSigner;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.CommonBatchSigner;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.gears.app.signature.PACKAGE;
import de.intarsys.security.device.gears.device.GearsDevice;
import de.intarsys.security.signature.common.ExtendedSignatureData;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.ISignatureDataList;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.SignatureDataList;
import de.intarsys.security.signature.common.SignatureTask;
import de.intarsys.security.signature.etsi.api.SignatureFormat;
import de.intarsys.security.standard.validation.ArgsValidationData;
import de.intarsys.tools.concurrent.ExecutorEnvironment;
import de.intarsys.tools.conversation.ConversationRegistry;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jaxrs.RequestContext;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GearsSigner
extends CommonBatchSigner {
    private static final Logger Log = LoggerFactory.getLogger(GearsSigner.class);
    private static final String ARG_DOCUMENT_SIGNER_ARGS_FORMAT = "documentSigner.args.format";
    private static final String ARG_DOCUMENT_SIGNER_ARGS_CONFORMANCELEVEL = "documentSigner.args.conformanceLevel";
    public static final String ARG_REMOTE_LABEL = "remote.label";
    public static final String ARG_REMOTE_ARGS = "remote.args";
    public static final String ARG_REMOTE_OPTIONS = "remote.options";
    public static final String ARG_REMOTE_VARIABLES = "remote.variables";
    public static final String ARG_REMOTE_CONFIGURATION = "remote.configuration";
    private static final String DIGEST_INFO_CONTENT_TYPE = "application/vnd.intarsys.asn1.digestinfo";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final Collection<String> SUPPORTED_DIGEST_ALGORITHMS = List.of("SHA-1", "SHA-256", "SHA-384", "SHA-512", "RIPEMD160", "RIPEMD256");
    private String remoteLabel;
    private IArgs remoteArgs;
    private IArgs remoteOptions;
    private IArgs remoteVariables;
    private Object remoteConfiguration;
    private List<String> supportedHashAlgorithmNames;
    private String preferredHashAlgorithmName;
    private ConversationStub signerStub;

    public GearsSigner(GearsDevice device) {
        super((CommonDevice)device);
        this.setApproximatedContainerSize(Short.MAX_VALUE);
    }

    protected void basicDispose() {
        super.basicDispose();
        if (this.getSignerStub() != null && !this.getSignerStub().getReplyStage().isFinal()) {
            try {
                this.getSignerStub().cancel();
                this.getSignerStub().acknowledge();
            }
            catch (GearsServiceException gearsServiceException) {
                // empty catch block
            }
        }
    }

    protected IConversation<?> basicSignAuthorized() {
        IConversation<?> conversation = this.gearsCallSignerCreate();
        return conversation.thenAccept(result -> {
            ISignatureDataList signatures = this.gearsToSignatureDataList((ResultSigner)result);
            this.tasksComplete(signatures.getSignatures());
        });
    }

    protected SignatureTask createSignatureTask(IToBeSignedData data) {
        SignatureTask task = super.createSignatureTask(data);
        try {
            this.setHashAlgorithmName(data.getDigest().getAlgorithmName());
        }
        catch (Exception e) {
            task.conversation.completeExceptionally((Throwable)e);
        }
        return task;
    }

    protected IConversation<?> gearsCallSignerCreate() {
        ConversationStubConversationAdapter adapter = new ConversationStubConversationAdapter();
        ConversationRegistry.publishForLifetime((IConversation)adapter.getConversation());
        try {
            RequestSignerCreate signRequest = this.gearsCreateRequestSignerCreate(adapter.getConversation());
            this.setSignerStub((ConversationStub)this.getDevice().getGearsStub().createSigner(signRequest));
            adapter.handle(this.getSignerStub());
        }
        catch (Exception exception) {
            String msg = Msg.getString("GearsSigner.unexpectedSignatureCreationError", new Object[0]);
            SecurityApplicationException ex = new SecurityApplicationException(msg, (Throwable)exception);
            adapter.getConversation().completeExceptionally((Throwable)ex);
        }
        return adapter.getConversation();
    }

    protected RequestSignerCreate gearsCreateRequestSignerCreate(IConversation conversation) {
        RequestSignerCreate request = new RequestSignerCreate();
        request.setLabel(this.getRemoteLabel());
        request.setArgs(this.getRemoteArgs());
        request.setOptions(this.getRemoteOptions());
        request.setConfiguration(this.getRemoteConfiguration());
        request.setVariables(this.getRemoteVariables());
        request.setDocuments(this.gearsCreateRequestSignerCreateDocuments());
        URI redirectUri = RequestContext.get().getUriBuilderContext().path("api/v1/flow/conversation/resume").queryParam("state", new Object[]{conversation.getHandle()}).queryParam("outcome", new Object[]{"ok"}).build(new Object[0]);
        FlowOptions.setRedirectUri((IOptionSupport)request, (Object)redirectUri);
        return request;
    }

    protected IArgs gearsCreateRequestSignerCreateArgs() {
        Args result;
        Object object = result = this.remoteArgs == null ? Args.create() : this.remoteArgs.copy();
        if (!ArgTools.isDefined((IArgs)result, (String)ARG_DOCUMENT_SIGNER_ARGS_FORMAT)) {
            SignatureFormat adesFamily = this.getSignatureFormat();
            if (adesFamily == SignatureFormat.CAdES) {
                ArgTools.putPath((IArgs)result, (String)ARG_DOCUMENT_SIGNER_ARGS_FORMAT, (Object)"CAdES-B");
            } else if (adesFamily == SignatureFormat.PAdES) {
                ArgTools.putPath((IArgs)result, (String)ARG_DOCUMENT_SIGNER_ARGS_FORMAT, (Object)"CMS/PAdES-B");
            }
        }
        if (!ArgTools.isDefined((IArgs)result, (String)ARG_DOCUMENT_SIGNER_ARGS_CONFORMANCELEVEL)) {
            String conformanceLevel = null;
            conformanceLevel = this.getSignatureOptions().isAddTimestamp() ? (this.getSignatureOptions().getValidationDataOptions().isAddValidationData() ? "LT" : "T") : "B";
            ArgTools.putPath((IArgs)result, (String)ARG_DOCUMENT_SIGNER_ARGS_CONFORMANCELEVEL, (Object)conformanceLevel);
        }
        return result;
    }

    protected List<TransportDocument> gearsCreateRequestSignerCreateDocuments() {
        ArrayList<TransportDocument> documents = new ArrayList<TransportDocument>();
        int index = 0;
        for (IToBeSignedData dataToBeSigned : this.tasksGetToBeSignedData()) {
            String name = "digest-" + index;
            TransportDocument document = TransportDocument.builder().contentType(DIGEST_INFO_CONTENT_TYPE).content((ILocator)new ByteArrayLocator(dataToBeSigned.getEncodedDigest(), name)).name(name).build();
            documents.add(document);
            ++index;
        }
        return documents;
    }

    protected ISignatureDataList gearsToSignatureDataList(ResultSigner result) throws SecurityApplicationException {
        ArrayList<ISignatureData> signatures = new ArrayList<ISignatureData>();
        for (TransportDocument document : result.getSignatures()) {
            try {
                byte[] encodedSignature = LocatorTools.getBytes((ILocator)document.getLocator());
                ArgsValidationData validationData = null;
                Object validationDataValue = document.getProperty("validationData");
                if (validationDataValue instanceof IArgs) {
                    IArgs validationDataArgs = (IArgs)validationDataValue;
                    validationData = new ArgsValidationData(validationDataArgs);
                }
                signatures.add(ExtendedSignatureData.create((byte[])encodedSignature, null, validationData));
            }
            catch (IOException exception) {
                String msg = Msg.getString("Gears.invalidSignatureData", new Object[0]);
                throw new SecurityApplicationException(msg, (Throwable)exception);
            }
        }
        return SignatureDataList.create(signatures);
    }

    public GearsDevice getDevice() {
        return (GearsDevice)super.getDevice();
    }

    public String getEncryptionAlgorithmName() {
        return "RSA";
    }

    public String getPreferredHashAlgorithmName() {
        if (this.preferredHashAlgorithmName != null && !SUPPORTED_DIGEST_ALGORITHMS.contains(this.preferredHashAlgorithmName)) {
            Log.warn("Hash algorithm name {} unsupported, using default", (Object)this.preferredHashAlgorithmName);
            return null;
        }
        return this.preferredHashAlgorithmName;
    }

    public IArgs getRemoteArgs() {
        return this.gearsCreateRequestSignerCreateArgs();
    }

    public Object getRemoteConfiguration() {
        return this.remoteConfiguration;
    }

    public String getRemoteLabel() {
        return this.remoteLabel;
    }

    public IArgs getRemoteOptions() {
        return this.remoteOptions;
    }

    public IArgs getRemoteVariables() {
        return this.remoteVariables;
    }

    protected ConversationStub getSignerStub() {
        return this.signerStub;
    }

    public Collection<String> getSupportedHashAlgorithmNames() {
        return this.supportedHashAlgorithmNames;
    }

    public boolean isBasic() {
        return false;
    }

    public void setPreferredHashAlgorithmName(String preferredHashAlgorithmName) {
        this.preferredHashAlgorithmName = preferredHashAlgorithmName;
    }

    public void setRemoteArgs(IArgs requestArgs) {
        this.remoteArgs = requestArgs;
    }

    public void setRemoteConfiguration(Object requestConfiguration) {
        this.remoteConfiguration = requestConfiguration;
    }

    public void setRemoteLabel(String requestLabel) {
        this.remoteLabel = requestLabel;
    }

    public void setRemoteOptions(IArgs requestOptions) {
        this.remoteOptions = requestOptions;
    }

    public void setRemoteVariables(IArgs requestVariables) {
        this.remoteVariables = requestVariables;
    }

    protected void setSignerStub(ConversationStub signerStub) {
        this.signerStub = signerStub;
    }

    public void setSupportedHashAlgorithmNames(List<String> supportedHashAlgorithmNames) {
        this.supportedHashAlgorithmNames = supportedHashAlgorithmNames;
    }

    protected Future<?> submit(Runnable runnable) {
        return ExecutorEnvironment.get().getService().submit(runnable);
    }
}

