/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.gears.app.signature;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.intarsys.tools.bean.BeanComponent;
import de.intarsys.tools.bean.BeanContainer;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.FilterResolver;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.json.Json;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.string.StringTools;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BeanComponent(role="gearsSignerPresets")
public class GearsSignerPresets
implements IElementConfigurable,
IElementSerializable {
    private static final Logger Log = LoggerFactory.getLogger(GearsSignerPresets.class);
    public static final String ARG_PRESETS = "presets";
    public static final String BEAN_ROLE_GEARSSIGNERPRESETS = "gearsSignerPresets";
    private String beanId;
    private String description;
    private String name;
    private String preferredHashAlgorithmName;
    private String signerConfiguration;
    private String signerArgs;
    private String signerOptions;
    private String signerVariables;
    private final ObjectMapper mapper = new ObjectMapper();

    public static GearsSignerPresets getDefault() {
        return GearsSignerPresets.lookupPresetsById("gears-presets-default").orElse(null);
    }

    public static Optional<GearsSignerPresets> getPresets(IArgs args) {
        Object presetsAny = ArgTools.getObject((IArgs)args, (String)ARG_PRESETS, null);
        return GearsSignerPresets.toPresets(presetsAny);
    }

    public static Collection<GearsSignerPresets> getRegisteredPresets() {
        return BeanContainer.get().lookupBeans(BEAN_ROLE_GEARSSIGNERPRESETS, GearsSignerPresets.class);
    }

    public static Optional<GearsSignerPresets> lookupPresets(Predicate<GearsSignerPresets> filter) {
        return GearsSignerPresets.getRegisteredPresets().stream().filter(filter).findAny();
    }

    public static Optional<GearsSignerPresets> lookupPresets(String value) {
        return GearsSignerPresets.lookupPresetsByName(value).or(() -> GearsSignerPresets.lookupPresetsById(value));
    }

    public static Optional<GearsSignerPresets> lookupPresetsById(String id) {
        return GearsSignerPresets.lookupPresets((GearsSignerPresets presets) -> LangTools.equals((Object)id, (Object)presets.getId()));
    }

    public static Optional<GearsSignerPresets> lookupPresetsByName(Predicate<GearsSignerPresets> filter, String name) {
        return GearsSignerPresets.getRegisteredPresets().stream().filter(filter).filter(presets -> presets.getName().equals(name)).findAny();
    }

    public static Optional<GearsSignerPresets> lookupPresetsByName(String name) {
        return GearsSignerPresets.lookupPresets((GearsSignerPresets presets) -> LangTools.equals((Object)name, (Object)presets.getName()));
    }

    public static GearsSignerPresets lookupPresetsOrDefault(String value) {
        return GearsSignerPresets.lookupPresetsByName(value).or(() -> GearsSignerPresets.lookupPresetsById(value)).orElse(GearsSignerPresets.getDefault());
    }

    private static IArgs toArgs(String argsString) {
        if (StringTools.isEmpty((String)argsString)) {
            return Args.create();
        }
        return ArgTools.toArgs((Object)argsString);
    }

    public static Optional<GearsSignerPresets> toPresets(Object presetsAny) {
        if (presetsAny == null) {
            return Optional.empty();
        }
        if (presetsAny instanceof GearsSignerPresets) {
            GearsSignerPresets p = (GearsSignerPresets)presetsAny;
            return Optional.of(p);
        }
        if (presetsAny instanceof String) {
            String s = (String)presetsAny;
            Optional<GearsSignerPresets> presetsOptional = GearsSignerPresets.lookupPresets(s);
            if (presetsOptional.isEmpty() && !StringTools.isEmpty((String)s)) {
                Log.warn("Presets '{}' not found. Not using presets.", (Object)s);
            }
            return presetsOptional;
        }
        throw ExceptionTools.argumentInvalid((String)ARG_PRESETS, null, null);
    }

    public void apply(IArgs args) {
        ArgTools.putAllDeep((IArgs)args, (IArgs)this.toSignerArgs());
    }

    public void configure(IElement element) throws ConfigurationException {
        this.beanId = element.attributeValue("bean-id", null);
    }

    protected IArgs expandLocal(IArgs args) {
        FilterResolver filter = new FilterResolver("client", ExpressionEvaluator.get((Mode)Mode.UNTRUSTED));
        TaggedStringEvaluator evaluator = TaggedStringEvaluator.decorate((IStringEvaluator[])new IStringEvaluator[]{filter});
        evaluator.setStrict(true);
        return ArgTools.expandDeep((IArgs)args, (IStringEvaluator)evaluator);
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        if (this.beanId == null) {
            this.beanId = UUID.randomUUID().toString();
        }
        return this.beanId;
    }

    public String getName() {
        return this.name;
    }

    public String getPreferredHashAlgorithmName() {
        return this.preferredHashAlgorithmName;
    }

    public String getSignerArgs() {
        return this.signerArgs;
    }

    public IArgs getSignerArgsExpanded() {
        return GearsSignerPresets.toArgs(this.getSignerArgs());
    }

    public String getSignerConfiguration() {
        return this.signerConfiguration;
    }

    public Object getSignerConfigurationExpanded() {
        String result = this.getSignerConfiguration();
        if (Json.isJson((String)result)) {
            try {
                return this.mapper.readValue(result, Object.class);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("signer configuration invalid (" + ExceptionTools.getMessage((Throwable)e) + ")", e);
            }
        }
        return result;
    }

    public String getSignerOptions() {
        return this.signerOptions;
    }

    public IArgs getSignerOptionsExpanded() {
        return GearsSignerPresets.toArgs(this.getSignerOptions());
    }

    public String getSignerVariables() {
        return this.signerVariables;
    }

    public IArgs getSignerVariablesExpanded() {
        return GearsSignerPresets.toArgs(this.getSignerVariables());
    }

    public boolean isDefault() {
        return GearsSignerPresets.getDefault() == this;
    }

    public void merge(IArgs args) {
        ArgTools.putAllIfAbsentDeep((IArgs)args, (IArgs)this.toSignerArgs());
    }

    public void register() {
        BeanContainer.get().registerBean(this.getId(), null, (Object)this);
    }

    public void serialize(IElement element) throws ElementSerializationException {
        element.setName("object");
        element.setAttributeValue("bean-id", this.getId());
        element.setAttributeValue("class", this.getClass().getName());
        this.serializeProperty(element, "name", this.getName());
        this.serializeProperty(element, "description", this.getDescription());
        this.serializeProperty(element, "preferredHashAlgorithmName", this.getPreferredHashAlgorithmName());
        this.serializeProperty(element, "signerConfiguration", this.getSignerConfiguration());
        this.serializeProperty(element, "signerOptions", this.getSignerOptions());
        this.serializeProperty(element, "signerVariables", this.getSignerVariables());
        this.serializeProperty(element, "signerArgs", this.getSignerArgs());
    }

    protected void serializeProperty(IElement element, String propertyName, String propertyValue) {
        if (!StringTools.isEmpty((String)propertyValue)) {
            IElement descriptionElement = element.newElementMapped("property");
            descriptionElement.setAttributeValue("name", propertyName);
            descriptionElement.setAttributeValue("value", propertyValue);
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPreferredHashAlgorithmName(String preferredHashAlgorithmName) {
        this.preferredHashAlgorithmName = preferredHashAlgorithmName;
    }

    public void setSignerArgs(String signerArgs) {
        this.signerArgs = signerArgs;
    }

    public void setSignerConfiguration(String signerConfiguration) {
        this.signerConfiguration = signerConfiguration;
    }

    public void setSignerOptions(String signerOptions) {
        this.signerOptions = signerOptions;
    }

    public void setSignerVariables(String signerVariables) {
        this.signerVariables = signerVariables;
    }

    protected IArgs toSignerArgs() {
        Args args = Args.create();
        if (!StringTools.isEmpty((String)this.preferredHashAlgorithmName)) {
            args.put("preferredHashAlgorithm", (Object)this.preferredHashAlgorithmName);
        }
        if (!StringTools.isEmpty((String)this.signerConfiguration)) {
            ArgTools.putPath((IArgs)args, (String)"remote.configuration", (Object)this.getSignerConfigurationExpanded());
        }
        if (!StringTools.isEmpty((String)this.getSignerOptions())) {
            args.put("remote.options", (Object)this.getSignerOptionsExpanded());
        }
        if (!StringTools.isEmpty((String)this.getSignerVariables())) {
            args.put("remote.variables", (Object)this.getSignerVariablesExpanded());
        }
        if (!StringTools.isEmpty((String)this.getSignerArgs())) {
            args.put("remote.args", (Object)this.getSignerArgsExpanded());
        }
        return this.expandLocal((IArgs)args);
    }

    public void unregister() {
        if (this.beanId == null) {
            return;
        }
        BeanContainer.get().unregisterBean(this.beanId);
    }
}

