/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.gears.device;

import de.intarsys.cloudsuite.gears.core.client.GearsStub;
import de.intarsys.cloudsuite.gears.core.client.HttpConfiguration;
import de.intarsys.cloudsuite.gears.core.client.IRequestProcessor;
import de.intarsys.cloudsuite.gears.core.client.Protocol;
import de.intarsys.cloudsuite.gears.core.client.auth.NoopRemoteAuthenticator;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.gears.device.GearsDeviceProvider;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.FactoredBy;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FactoredBy(factory=GearsDeviceProvider.class)
public class GearsDevice
extends CommonDevice<GearsDeviceProvider> {
    public static final String LIC_PRODUCT = "de.intarsys.security.device.gears";
    public static final String ARG_HTTP_CONFIGURATION = "httpConfiguration";
    public static final String ARG_BASE_URL = "baseUrl";
    public static final String ARG_AUTHENTICATOR = "authenticator";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private GearsStub gearsStub;

    public GearsDevice(GearsDeviceProvider provider, String id) {
        super((CommonDeviceProvider)provider, id);
    }

    public void configure(IArgs args) throws Exception {
        URL baseUrl;
        super.configure(args);
        HttpConfiguration httpConfiguration = HttpConfiguration.get((IArgs)args, (String)ARG_HTTP_CONFIGURATION);
        if (httpConfiguration == null) {
            httpConfiguration = HttpConfiguration.createDefault();
        }
        if ((baseUrl = ArgTools.getUrlStrict((IArgs)args, (String)ARG_BASE_URL, null)) == null) {
            throw ExceptionTools.argumentRequired((String)ARG_BASE_URL);
        }
        InstanceSpec defaultSpec = InstanceSpec.createFromValue(IRequestProcessor.class, (Object)NoopRemoteAuthenticator.INSTANCE);
        InstanceSpec authenticatorSpec = InstanceSpec.get((IArgs)args, (String)ARG_AUTHENTICATOR, IRequestProcessor.class, (InstanceSpec)defaultSpec);
        IRequestProcessor authenticator = (IRequestProcessor)authenticatorSpec.createInstance();
        Protocol protocol = new Protocol(baseUrl, httpConfiguration);
        protocol.addRequestProcessor(authenticator);
        this.gearsStub = new GearsStub(protocol);
    }

    protected String createBasicToken(String user, String password) {
        return Base64.getEncoder().encodeToString((user + ":" + password).getBytes(StandardCharsets.ISO_8859_1));
    }

    public GearsStub getGearsStub() {
        return this.gearsStub;
    }

    protected void logConfiguration() {
        super.logConfiguration();
        this.logger.info("  +-- baseUrl: {}", (Object)this.gearsStub.getProtocol().getEndpoint());
        this.logger.info("  +-- httpConfiguration: {}", (Object)this.gearsStub.getProtocol().getHttpConfiguration());
    }
}

