/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.gears.device;

import de.intarsys.cloudsuite.gears.core.client.HttpConfiguration;
import de.intarsys.cloudsuite.gears.core.client.IRequestProcessor;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.common.CommonDeviceFactoryBean;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.gears.device.GearsDevice;
import de.intarsys.security.device.gears.device.GearsDevicePreferences;
import de.intarsys.security.device.gears.device.GearsDeviceProvider;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GearsDeviceInstaller
extends CommonDeviceFactoryBean<GearsDevice> {
    private static final Logger Log = LoggerFactory.getLogger(GearsDeviceInstaller.class);
    private URL baseUrl;
    private HttpConfiguration httpConfiguration;
    private IRequestProcessor authenticator;

    protected IArgs createArgs() throws Exception {
        if (this.getBaseUrl() != null) {
            return this.createArgsFromProperties();
        }
        if (GearsDevicePreferences.get().getPrefsBaseUrl() != null) {
            return this.createArgsFromPreferences();
        }
        return null;
    }

    protected IArgs createArgsFromPreferences() throws Exception {
        Log.debug("create args from preferences");
        Args args = Args.create();
        args.put("id", (Object)"default");
        args.put("httpConfiguration", GearsDevicePreferences.get().getPrefsHttpConfiguration());
        args.put("baseUrl", (Object)GearsDevicePreferences.get().getPrefsBaseUrl());
        args.put("authenticator", (Object)GearsDevicePreferences.get().getPrefsAuthenticator());
        return args;
    }

    protected IArgs createArgsFromProperties() {
        Log.debug("create args from properties");
        Args args = Args.create();
        args.put("id", (Object)(StringTools.isEmpty((String)this.getId()) ? "default" : this.getId()));
        args.put("httpConfiguration", (Object)this.getHttpConfiguration());
        args.put("baseUrl", (Object)this.getBaseUrl());
        args.put("authenticator", (Object)this.getAuthenticator());
        return args;
    }

    protected CommonDeviceProvider createDeviceProvider() {
        return (CommonDeviceProvider)DeviceTools.lookupDeviceProvider(GearsDeviceProvider.class);
    }

    protected GearsDevice createInstance() throws Exception {
        IArgs args = this.createArgs();
        if (args == null) {
            Log.debug("no device definition found, skip");
            return null;
        }
        return (GearsDevice)this.getDeviceProviderOrDefault().createInstance(args);
    }

    public IRequestProcessor getAuthenticator() {
        return this.authenticator;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public GearsDeviceProvider getDeviceProvider() {
        return (GearsDeviceProvider)super.getDeviceProvider();
    }

    public GearsDeviceProvider getDeviceProviderOrDefault() {
        return (GearsDeviceProvider)super.getDeviceProviderOrDefault();
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public Class<?> getObjectType() {
        return GearsDevice.class;
    }

    public void setAuthenticator(IRequestProcessor authenticator) {
        this.authenticator = authenticator;
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setHttpConfiguration(HttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
    }
}

