/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.gears.device;

import de.intarsys.cloudsuite.gears.core.client.HttpConfiguration;
import de.intarsys.cloudsuite.gears.core.client.IRequestProcessor;
import de.intarsys.cloudsuite.gears.core.client.auth.UserPasswordAuthenticator;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.standard.IdCertificateProvider;
import de.intarsys.security.environment.SecurityEnvironment;
import de.intarsys.security.ssl.CertificateBasedKeyManagerProvider;
import de.intarsys.tools.authenticate.PasswordProvider;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.preferences.PreferencesTools;
import de.intarsys.tools.ssl.IConfigurableSslContextProvider;
import de.intarsys.tools.ssl.IKeyManagerProvider;
import de.intarsys.tools.ssl.SslContextProvider;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;

public class GearsDevicePreferences
implements IPreferencesSupport {
    public static final String PREF_BASICAUTH_PASSWORD = "basicAuthPassword";
    public static final String PREF_BASICAUTH_QUALIFIEDUSERNAME = "basicAuthQualifiedUserName";
    public static final String PREF_CLIENTCERT_PASSWORD = "clientCertPassword";
    public static final String PREF_CLIENTCERT = "clientCert";
    public static final String PREF_URL = "url";
    public static final String PREF_USEBASICAUTH = "useBasicAuth";
    public static final String PREF_USECLIENTCERT = "useClientCert";
    private static final GearsDevicePreferences ACTIVE = new GearsDevicePreferences();
    private IPreferences preferences;

    public static GearsDevicePreferences get() {
        return ACTIVE;
    }

    protected IPreferences createPreferences() {
        IPreferences root = PreferencesFactory.get().getRoot();
        IPreferences tmpPrefs = root.node(this.getPreferencesName());
        this.preferencesInit(tmpPrefs.restrict("DEFAULT"));
        return tmpPrefs;
    }

    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return "de.intarsys.prefs.security.gears";
    }

    protected IRequestProcessor getPrefsAuthenticator() {
        if (!this.getPrefsUseBasicAuth()) {
            return null;
        }
        return new UserPasswordAuthenticator(this.getPrefsBasicAuthUser(), this.getPrefsBasicAuthUser());
    }

    protected URL getPrefsBaseUrl() {
        return ArgTools.toUrl((String)PREF_URL, (Object)this.getPreferences().get(PREF_URL), null);
    }

    protected Secret getPrefsBasicAuthPassword() {
        return PreferencesTools.getSecret((IPreferences)this.getPreferences(), (String)PREF_BASICAUTH_PASSWORD, (Secret)Secret.EMPTY);
    }

    protected String getPrefsBasicAuthUser() {
        return this.getPreferences().get(PREF_BASICAUTH_QUALIFIEDUSERNAME);
    }

    protected Object getPrefsHttpConfiguration() throws Exception {
        return HttpConfiguration.builder().sslContext(this.getPrefsSslContext()).build();
    }

    protected SSLContext getPrefsSslContext() throws GeneralSecurityException, IOException {
        if (this.getPrefsUseClientCert()) {
            ICertificateProvider provider = IdCertificateProvider.get();
            String selector = this.getPreferences().get(PREF_CLIENTCERT);
            if (selector == null) {
                return null;
            }
            CertificateBasedKeyManagerProvider keyManagerProvider = new CertificateBasedKeyManagerProvider();
            keyManagerProvider.setCertificateProvider(provider);
            keyManagerProvider.setKeyPasswordProvider(cert -> this.getPrefsSslPassword((IX509PublicKeyCertificate)cert));
            keyManagerProvider.setSelector((Object)selector);
            IConfigurableSslContextProvider sslContextProvider = SslContextProvider.get().createProvider();
            sslContextProvider.setKeyManagerProvider((IKeyManagerProvider)keyManagerProvider);
            return sslContextProvider.createSslContext();
        }
        return SslContextProvider.get().createSslContext();
    }

    protected Secret getPrefsSslPassword(IX509PublicKeyCertificate cert) {
        Secret password = PreferencesTools.getSecret((IPreferences)this.getPreferences(), (String)PREF_CLIENTCERT_PASSWORD, null);
        if (password == null) {
            String id = CertificateTools.getUniqueIdentifier((IX509PublicKeyCertificate)cert);
            password = SecurityEnvironment.get().getSecret(id);
        }
        if (password == null) {
            password = PasswordProvider.get().getPassword();
        }
        return password;
    }

    protected boolean getPrefsUseBasicAuth() {
        return this.getPreferences().getBoolean(PREF_USEBASICAUTH);
    }

    protected boolean getPrefsUseClientCert() {
        return this.getPreferences().getBoolean(PREF_USECLIENTCERT);
    }

    protected void preferencesInit(IPreferences restrict) {
    }
}

