/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.gears.device;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.signature.CommonSignerPolicy;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.gears.app.signature.GearsSignerFactory;
import de.intarsys.security.device.gears.device.GearsDevice;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PostConstruct;
import java.util.List;

public class GearsDeviceProvider
extends CommonDeviceProvider<GearsDevice> {
    public GearsDeviceProvider() {
        this.setId("gears");
    }

    protected GearsDevice basicCreateInstance(IArgs args) throws ObjectCreationException {
        return new GearsDevice(this, this.getId(args));
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> apps) {
        super.declareApplicationDescriptors(apps);
        GearsSignerFactory signer = new GearsSignerFactory();
        signer.setType(ISigner.class);
        signer.setDeviceProvider(this);
        signer.setLicenseAccountSupplier(() -> this.declareLicenseAccountSign());
        signer.setPolicy((IApplicationPolicy)new CommonSignerPolicy((CommonDeviceProvider)this));
        apps.add((IApplicationDescriptor)signer);
    }

    protected ILicenseAccount declareLicenseAccountSignBasic() {
        ILicenseAccount account = this.getLicenseProduct().getAccount("de.intarsys.security.app.sign.account");
        account.setDefaultValueUnit(10, LicensePropertyUnit.PER_MINUTE);
        return account;
    }

    protected LicenseProduct declareLicenseProduct() {
        return LicenseTools.createProduct((Object)((Object)this), (String)"de.intarsys.security.device.gears");
    }

    @PostConstruct
    public void init() {
        super.init();
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
    }
}

