/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.gears.processor;

import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.gears.app.signature.GearsSigner;
import de.intarsys.security.device.gears.app.signature.GearsSignerPresets;
import de.intarsys.security.device.gears.device.GearsDeviceProvider;
import de.intarsys.security.device.processor.CommonSignerFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.util.Collection;
import java.util.Optional;

public class GearsDigestSignerFactory
extends CommonSignerFactory<ISigner> {
    private static Optional<GearsSignerPresets> extractPresetsFromDevice(IArgs args) {
        Optional<GearsSignerPresets> presetsOptional;
        String deviceString = ArgTools.getString((IArgs)args, (String)"device", null);
        if (StringTools.isEmpty((String)deviceString)) {
            presetsOptional = Optional.empty();
        } else {
            String[] tokens = deviceString.split("@");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("invalid device");
            }
            if (!"gears".equals(tokens[1])) {
                throw new IllegalArgumentException("invalid device");
            }
            presetsOptional = GearsSignerPresets.lookupPresets(tokens[0]);
        }
        return presetsOptional;
    }

    protected GearsSigner basicCreateInstance(IArgs args) throws ObjectCreationException {
        IDevice device;
        block2: {
            try {
                device = DeviceTools.getDevice((IArgs)args, (String)"device", GearsDeviceProvider.class);
            }
            catch (ObjectCreationException e) {
                device = DeviceTools.getDefaultDevice(GearsDeviceProvider.class);
                Optional<GearsSignerPresets> presetsDevice = GearsDigestSignerFactory.extractPresetsFromDevice(args);
                if (!presetsDevice.isPresent()) break block2;
                args.put("presets", (Object)presetsDevice.get().getId());
            }
        }
        return (GearsSigner)device.createApplication(ISigner.class.getName(), args);
    }

    public Collection<String> getSupportedHashAlgorithmNames() {
        return GearsSigner.SUPPORTED_DIGEST_ALGORITHMS;
    }

    public boolean supportsPkcs1() {
        return true;
    }
}

