/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.demo.app;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.CommonSingleSigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.demo.device.DemoDevice;
import de.intarsys.security.device.demo.device.DemoPrincipal;
import de.intarsys.security.privatekey.KeyCertificatePair;
import de.intarsys.tools.conversation.IConversation;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public abstract class DemoSigner
extends CommonSingleSigner {
    public static final Collection<String> SUPPORTED_DIGEST_ALGORITHMS = Collections.unmodifiableList(Arrays.asList("MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512", "RIPEMD160", "RIPEMD256"));
    private final DemoPrincipal principal;

    protected DemoSigner(DemoDevice device, DemoPrincipal principal) {
        super((CommonDevice)device);
        this.principal = principal;
    }

    protected IConversation<Void> basicAuthenticate() {
        return super.basicAuthenticate().thenAccept(ignore -> {
            PrivateKey key = this.getEntity().getPrivateKey();
            this.init(key);
        });
    }

    protected IPrincipal createPrincipal(IX509PublicKeyCertificate certificate) {
        return null;
    }

    public DemoDevice getDevice() {
        return (DemoDevice)super.getDevice();
    }

    public String getEncryptionAlgorithmName() {
        return this.getCertificate().getPublicKey().getAlgorithm();
    }

    protected KeyCertificatePair getEntity() {
        return this.getPrincipal().getIdentity().getEntity();
    }

    public String getLabel() {
        return "Demo signer";
    }

    public DemoPrincipal getPrincipal() {
        return this.principal;
    }

    public Collection<String> getSupportedHashAlgorithmNames() {
        return SUPPORTED_DIGEST_ALGORITHMS;
    }

    public void init() {
        super.init();
        this.setCertificatePath(new IX509PublicKeyCertificate[]{this.getEntity().getCertificate()});
    }

    protected abstract void init(PrivateKey var1) throws SecurityApplicationException;

    public boolean isBasic() {
        return true;
    }
}

