/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.demo.app;

import de.intarsys.security.algorithm.common.PpkTools;
import de.intarsys.security.app.signature.CommonSignerFactory;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IPrincipalFilter;
import de.intarsys.security.device.common.PrincipalFilterTools;
import de.intarsys.security.device.demo.app.DemoSigner;
import de.intarsys.security.device.demo.app.DemoSignerEC;
import de.intarsys.security.device.demo.app.DemoSignerRSAPKCS1;
import de.intarsys.security.device.demo.app.DemoSignerRSAPSS;
import de.intarsys.security.device.demo.device.DemoDevice;
import de.intarsys.security.device.demo.device.DemoPrincipal;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.Iterator;

public class DemoSignerFactory
extends CommonSignerFactory<DemoDevice, DemoSigner> {
    public static final String ARG_RSASIGNATUREENCODING = "rsaSignatureEncoding";
    public static final String RSASIGNATUREENCODING_RSA = "RSA";
    public static final String RSASIGNATUREENCODING_RSASSAPSS = "RSASSA-PSS";
    private String defaultRsaSignatureEncoding;

    protected DemoSigner basicCreateApp(IArgs args) throws ObjectCreationException {
        try {
            DemoSigner app;
            IX509PublicKeyCertificate cert;
            Iterator itPrincipals;
            DemoPrincipal principal = null;
            IPrincipalFilter filter = PrincipalFilterTools.createFilter((IArgs)args);
            if (filter != null && (itPrincipals = ((DemoDevice)this.getDevice(args)).listPrincipals(filter)).hasNext()) {
                principal = (DemoPrincipal)((Object)itPrincipals.next());
            }
            if (principal == null) {
                String principalId = ArgTools.getString((IArgs)args, (String)"principalId", null);
                principal = ((DemoDevice)this.getDevice(args)).getPrincipal(principalId);
            }
            if (PpkTools.isSignatureAlgorithmECDSA((String)(cert = principal.getX509PublicKeyCertificate()).getPublicKey().getAlgorithm())) {
                app = new DemoSignerEC((DemoDevice)this.getDevice(args), principal);
            } else {
                String encoding;
                switch (encoding = ArgTools.getString((IArgs)args, (String)ARG_RSASIGNATUREENCODING, (String)this.getDefaultRsaSignatureEncoding())) {
                    case "RSA": {
                        app = new DemoSignerRSAPKCS1((DemoDevice)this.getDevice(args), principal);
                        break;
                    }
                    case "RSASSA-PSS": {
                        app = new DemoSignerRSAPSS((DemoDevice)this.getDevice(args), principal);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported encoding: " + encoding);
                    }
                }
            }
            return app;
        }
        catch (Exception e) {
            throw (ObjectCreationException)ExceptionTools.createTypedFromChain((Throwable)e, ObjectCreationException.class);
        }
    }

    protected String getArgNamePassword() {
        return "signerPassword";
    }

    public String getDefaultRsaSignatureEncoding() {
        if (this.defaultRsaSignatureEncoding == null) {
            this.defaultRsaSignatureEncoding = RSASIGNATUREENCODING_RSA;
        }
        return this.defaultRsaSignatureEncoding;
    }

    public Class<DemoSigner> getResultType() {
        return DemoSigner.class;
    }

    public void setDefaultRsaSignatureEncoding(String defaultRsaSignatureEncoding) {
        this.defaultRsaSignatureEncoding = defaultRsaSignatureEncoding;
    }
}

