/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.demo.app;

import de.intarsys.security.algorithm.rsa.RsaTools;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.device.demo.app.DemoSignerRSA;
import de.intarsys.security.device.demo.device.DemoDevice;
import de.intarsys.security.device.demo.device.DemoPrincipal;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import java.security.PrivateKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class DemoSignerRSAPKCS1
extends DemoSignerRSA {
    private Cipher rsaCipher;

    public DemoSignerRSAPKCS1(DemoDevice device, DemoPrincipal principal) {
        super(device, principal);
    }

    protected void basicDeauthenticate() throws SecurityApplicationException {
        super.basicDeauthenticate();
        this.rsaCipher = null;
    }

    protected void basicDispose() {
        super.basicDispose();
        this.rsaCipher = null;
    }

    protected IConversation<ISignatureData> basicSignSingle(IToBeSignedData data) {
        try {
            byte[] pkcs1 = this.rsaCipher.doFinal(data.getEncodedDigest());
            return Conversation.completed((Object)SignatureData.create((byte[])pkcs1));
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            return Conversation.failed((Throwable)new SecurityApplicationException((Throwable)e));
        }
    }

    @Override
    protected void init(PrivateKey privateKey) throws SecurityApplicationException {
        try {
            this.rsaCipher = RsaTools.lookupRSACipher((String)"BC");
            this.rsaCipher.init(1, privateKey);
        }
        catch (Exception e) {
            throw new SecurityApplicationException("wrong algorithm", (Throwable)e);
        }
    }
}

