/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.demo.app;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.device.demo.app.DemoSignerRSA;
import de.intarsys.security.device.demo.device.DemoDevice;
import de.intarsys.security.device.demo.device.DemoPrincipal;
import de.intarsys.security.encoding.PSSEncoding;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;

public class DemoSignerRSAPSS
extends DemoSignerRSA {
    private Signature signature;

    public DemoSignerRSAPSS(DemoDevice device, DemoPrincipal principal) {
        super(device, principal);
    }

    protected void basicDeauthenticate() throws SecurityApplicationException {
        super.basicDeauthenticate();
        this.signature = null;
    }

    protected void basicDispose() {
        super.basicDispose();
        this.signature = null;
    }

    protected IConversation<ISignatureData> basicSignSingle(IToBeSignedData data) {
        try {
            this.setAlgorithmParameterSpec(PSSEncoding.createPSSParameterSpec((String)data.getDigest().getAlgorithmName()));
            this.signature.setParameter(this.getAlgorithmParameterSpec());
            this.signature.update(data.getDigest().getBytes());
            return Conversation.completed((Object)SignatureData.create((byte[])this.signature.sign()));
        }
        catch (InvalidAlgorithmParameterException | SignatureException e) {
            return Conversation.failed((Throwable)new SecurityApplicationException((Throwable)e));
        }
    }

    @Override
    protected void init(PrivateKey privateKey) throws SecurityApplicationException {
        try {
            this.signature = Signature.getInstance("RAWRSASSA-PSS", "BC");
            this.signature.initSign(privateKey);
        }
        catch (GeneralSecurityException e) {
            throw new SecurityApplicationException("unexpected exception", (Throwable)e);
        }
    }
}

