/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.demo.device;

import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.demo.device.DemoCredential;
import de.intarsys.security.device.demo.device.DemoDeviceProvider;
import de.intarsys.security.device.demo.device.DemoPrincipal;
import de.intarsys.security.device.demo.device.PACKAGE;
import de.intarsys.security.identity.Identity;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.event.CreatedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.factory.FactoredBy;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.FileLocatorFactory;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.valueholder.IValueHolder;
import de.intarsys.tools.valueholder.ValueHolderAdapter;
import java.io.File;

@FactoredBy(factory=DemoDeviceProvider.class)
public class DemoDevice
extends CommonDevice<DemoDeviceProvider> {
    private static final Attribute ATTR_PRINCIPAL = new Attribute("principal");
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final String LIC_PRODUCT = "de.intarsys.security.device.demo";
    private DemoPrincipal mainPrincipal;
    private String identityName;
    private IArgs args;
    private ILocatorFactory locatorFactory = FileLocatorFactory.DATADIR;

    protected DemoDevice(DemoDeviceProvider deviceProvider, String name) {
        super((CommonDeviceProvider)deviceProvider, name);
    }

    protected ISecurityApplication basicCreateApplication(Class<ISecurityApplication> clazz, IArgs args) throws ObjectCreationException {
        ISecurityApplication app = super.basicCreateApplication(clazz, args);
        this.triggerEvent((Event)new CreatedEvent((Object)this, (Object)app));
        return app;
    }

    public DemoCredential createCredential() {
        return new DemoCredential(this);
    }

    protected Identity createIdentity(String identifier) throws ObjectCreationException {
        Args resolvedArgs = Args.create();
        resolvedArgs.put("locatorFactory", (Object)this.getLocatorFactory());
        resolvedArgs.put("persistent", (Object)ArgTools.getBoolStrict((IArgs)this.getArgs(), (String)"persistent", (boolean)false));
        resolvedArgs.put("key", (Object)ArgTools.getArgs((IArgs)this.getArgs(), (String)"key", (IArgs)Args.create()).copy());
        resolvedArgs.put("certificate", (Object)ArgTools.getArgs((IArgs)this.getArgs(), (String)"certificate", (IArgs)Args.create()).copy());
        ArgTools.putPathIfAbsent((IArgs)resolvedArgs, (String)"certificate.commonName", (Object)identifier);
        ArgTools.putPathIfAbsent((IArgs)resolvedArgs, (String)"certificate.country", (Object)"DE");
        ArgTools.expandDeep((IArgs)resolvedArgs, (IStringEvaluator)TemplateEvaluator.get((Mode)Mode.TRUSTED));
        return Identity.create((String)identifier, (IArgs)resolvedArgs);
    }

    protected String createLabel() {
        return Msg.getString("DemoDevice.label", new Object[0]);
    }

    protected DemoPrincipal createPrincipal(Identity identity) {
        DemoPrincipal principal = (DemoPrincipal)((Object)identity.getEntity().getCertificate().getAttribute((Object)ATTR_PRINCIPAL));
        if (principal == null) {
            principal = new DemoPrincipal((IDevice)this, identity);
            identity.getEntity().getCertificate().setAttribute((Object)ATTR_PRINCIPAL, (Object)principal);
        }
        return principal;
    }

    public IArgs getArgs() {
        return this.args;
    }

    public String getIdentityName() {
        return this.identityName;
    }

    public ILocatorFactory getLocatorFactory() {
        return this.locatorFactory;
    }

    public DemoPrincipal getMainPrincipal() {
        return this.mainPrincipal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DemoPrincipal getPrincipal(String identifier) throws ObjectCreationException {
        if (StringTools.isEmpty((String)identifier)) {
            return this.getMainPrincipal();
        }
        DemoDevice demoDevice = this;
        synchronized (demoDevice) {
            DemoPrincipal resolved = this.getPrincipals().stream().filter(p -> p.getId().equals(identifier)).findFirst().orElse(null);
            if (resolved == null) {
                resolved = this.createPrincipal(this.createIdentity(identifier));
                this.registerPrincipal((IPrincipal)resolved);
            }
            return resolved;
        }
    }

    protected void initBasic() throws Exception {
        super.initBasic();
        this.setLocatorFactory((ILocatorFactory)new FileLocatorFactory((IValueHolder)new ValueHolderAdapter<File>(){

            public File get() {
                return new File(FileEnvironment.get().getDataDir(), "identities/" + ((DemoDeviceProvider)DemoDevice.this.getDeviceProvider()).getId() + "/" + DemoDevice.this.getId());
            }
        }));
        String name = StringTools.isEmpty((String)this.getIdentityName()) ? this.getId() : this.getIdentityName();
        this.mainPrincipal = this.getPrincipal(name);
    }

    public void setArgs(IArgs args) {
        this.args = args;
        this.setIdentityName(ArgTools.getString((IArgs)args, (String)"identityName", null));
    }

    public void setIdentityName(String identityName) {
        this.identityName = identityName;
    }

    public void setLocatorFactory(ILocatorFactory locatorFactory) {
        this.locatorFactory = locatorFactory;
    }

    public void setMainPrincipal(DemoPrincipal mainPrincipal) {
        this.mainPrincipal = mainPrincipal;
    }
}

