/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.demo.device;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.NoPolicy;
import de.intarsys.security.app.authentication.IAuthenticator;
import de.intarsys.security.app.signature.CommonSignerPolicy;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.demo.app.DemoAuthenticatorFactory;
import de.intarsys.security.device.demo.app.DemoSignerFactory;
import de.intarsys.security.device.demo.device.DemoDevice;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementArgsAdapter;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PostConstruct;
import java.util.List;

public class DemoDeviceProvider
extends CommonDeviceProvider<DemoDevice> {
    private final CommonSignerPolicy signerPolicy = new CommonSignerPolicy((CommonDeviceProvider)this);

    public DemoDeviceProvider() {
        super("demo");
    }

    protected DemoDevice basicCreateInstance(IArgs args) throws ObjectCreationException {
        DemoDevice device = new DemoDevice(this, this.getId(args));
        device.setArgs(args);
        return device;
    }

    protected DemoDevice basicLookupInstance(IArgs args) throws ObjectCreationException {
        return null;
    }

    protected void configureDevice(IElement elDevice) throws ConfigurationException {
        try {
            IElement elKey;
            String idString = elDevice.attributeValue("id", null);
            if (idString == null) {
                throw new ObjectCreationException("'id' required");
            }
            Args args = Args.create();
            args.put("id", (Object)idString);
            args.put("persistent", (Object)elDevice.attributeValue("persistent", null));
            IElement elCertificate = elDevice.element("certificate");
            if (elCertificate != null) {
                Args certificate = Args.create();
                ArgTools.putAll((IArgs)certificate, (IArgs)new ElementArgsAdapter(elCertificate));
                args.put("certificate", (Object)certificate);
            }
            if ((elKey = elDevice.element("key")) != null) {
                Args key = Args.create();
                ArgTools.putAll((IArgs)key, (IArgs)new ElementArgsAdapter(elKey));
                args.put("key", (Object)key);
            }
            this.createInstance((IArgs)args);
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> apps) {
        super.declareApplicationDescriptors(apps);
        Object descriptor = new DemoSignerFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setLicenseAccountSupplier(() -> this.declareLicenseAccountSign());
        descriptor.setPolicy((IApplicationPolicy)this.signerPolicy);
        descriptor.setType(ISigner.class);
        apps.add((IApplicationDescriptor)descriptor);
        descriptor = new DemoAuthenticatorFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setPolicy((IApplicationPolicy)new NoPolicy((CommonDeviceProvider)this));
        descriptor.setType(IAuthenticator.class);
        apps.add((IApplicationDescriptor)descriptor);
    }

    protected LicenseProduct declareLicenseProduct() {
        return LicenseTools.createProduct((Object)((Object)this), (String)"de.intarsys.security.device.demo", (boolean)true);
    }

    @PostConstruct
    public void init() {
        super.init();
        IElement policyElement = ElementTools.getPathElement((IElement)this.getConfiguration(), (String[])new String[]{"policies", "signer"});
        if (policyElement != null) {
            try {
                this.signerPolicy.configure(policyElement);
            }
            catch (ConfigurationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
    }
}

