/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.demo;

import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.demo.device.DemoDeviceProvider;
import de.intarsys.security.device.pool.demo.PACKAGE;
import de.intarsys.security.device.pool.impl.AcceptException;
import de.intarsys.security.device.pool.impl.GenericPool;
import de.intarsys.security.device.pool.impl.IPoolListener;
import de.intarsys.security.device.pool.impl.PoolEntry;
import de.intarsys.tools.format.Format;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.reporter.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class DemoPoolListener<T extends ISecurityApplication>
implements IPoolListener<T> {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(DemoPoolListener.class);
    private final GenericPool pool;
    private DemoDeviceProvider deviceProvider;

    public DemoPoolListener(GenericPool pool) {
        this.pool = pool;
    }

    public void authenticate(GenericPool<T> pool, PoolEntry<T> result) throws AcceptException, SecurityApplicationException {
    }

    protected Class<ISigner> getApplicationType() {
        return ISigner.class;
    }

    public DemoDeviceProvider getDeviceProvider() {
        return this.deviceProvider;
    }

    protected IDeviceProvider getDeviceProviderOrDefault() {
        DemoDeviceProvider provider = this.getDeviceProvider();
        if (provider == null) {
            provider = (IDeviceProvider)DeviceTools.lookupDeviceProvider(DemoDeviceProvider.class);
        }
        return provider;
    }

    protected Object getLogLabel() {
        return this.toString();
    }

    public GenericPool<T> getPool() {
        return this.pool;
    }

    protected void housekeeping() {
    }

    public void onStartAfter(GenericPool pool) {
        try {
            this.openApplications();
        }
        catch (AcceptException e) {
            Log.warn(e.getLocalizedMessage(), (Throwable)e);
            Reporter.get().reportError(Msg.getString("DemoPoolPolicy.report.title", new Object[0]), e.getLocalizedMessage(), (Throwable)e, 0);
        }
    }

    public void onStartBefore(GenericPool pool) {
    }

    public void onStopAfter(GenericPool<T> pool) {
    }

    public void onStopBefore(GenericPool<T> pool) {
    }

    protected void openApplication() throws AcceptException {
        ISecurityApplication app = null;
        try {
            Args args = Args.create();
            IDeviceProvider provider = this.getDeviceProviderOrDefault();
            IDevice device = (IDevice)provider.listDevices(null).next();
            app = (ISecurityApplication)device.createApplication(ISigner.class.getName(), (IArgs)args);
            String label = Format.simple((String)"Pool {} sign application {}", (Object[])new Object[]{this.getPool().getLabel(), device.getId()});
            this.getPool().addApplication(app, label);
        }
        catch (AcceptException e) {
            if (app != null) {
                app.dispose();
            }
            throw e;
        }
        catch (Exception e) {
            if (app != null) {
                app.dispose();
            }
            if (Log.isEnabledForLevel(Level.DEBUG)) {
                Log.debug(this + " can't open application");
            }
            String msg = Msg.getString("DemoPoolPolicy.ErrorAcceptCantOpenApplication", new Object[]{this.getPool().getLabel()});
            throw new AcceptException(msg, (Throwable)e);
        }
    }

    protected void openApplications() throws AcceptException {
        this.openApplication();
    }

    public void preferencesRestore(IPreferences prefs) {
    }

    public void preferencesStore(IPreferences prefs) {
    }

    public void refresh() {
    }

    public void retry(GenericPool<T> genericPool, PoolEntry<T> entry) {
    }

    public void setDeviceProvider(DemoDeviceProvider deviceProvider) {
        this.deviceProvider = deviceProvider;
    }
}

