/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.acroform;

import de.intarsys.pdf.app.acroform.IFormHandler;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonFormHandler
implements IFormHandler {
    private PDDocument doc;
    private PDAcroForm acroForm;
    private boolean validate = true;
    private boolean calculate = true;

    protected CommonFormHandler(PDDocument doc) {
        this.doc = doc;
        if (doc.getAcroForm() == null) {
            throw new IllegalArgumentException("doc has no form");
        }
        this.acroForm = this.getDoc().getAcroForm();
    }

    protected abstract void basicRecalculate(PDAcroFormField var1);

    protected abstract void basicSetFieldValue(PDAcroFormField var1, List var2);

    protected abstract void basicSetFieldValue(PDAcroFormField var1, PDSignature var2);

    protected abstract void basicSetFieldValue(PDAcroFormField var1, String var2);

    protected abstract void doResetFields(List var1);

    protected PDAcroForm getAcroForm() {
        return this.acroForm;
    }

    @Override
    public PDDocument getDoc() {
        return this.doc;
    }

    @Override
    public String getFieldValue(Object fieldref) {
        PDAcroFormField field = this.marshalField(fieldref);
        return field.getValueString();
    }

    @Override
    public boolean isCalculate() {
        return this.calculate;
    }

    @Override
    public boolean isValidate() {
        return this.validate;
    }

    protected PDAcroFormField marshalField(Object fieldRef) {
        if (fieldRef instanceof PDWidgetAnnotation) {
            return ((PDWidgetAnnotation)fieldRef).getAcroFormField();
        }
        if (fieldRef instanceof PDAcroFormField) {
            return (PDAcroFormField)fieldRef;
        }
        if (fieldRef instanceof COSString) {
            fieldRef = ((COSString)fieldRef).stringValue();
        }
        if (fieldRef instanceof COSName) {
            fieldRef = ((COSName)fieldRef).stringValue();
        }
        if (fieldRef instanceof String) {
            return this.getAcroForm().getField((String)fieldRef);
        }
        throw new IllegalArgumentException("fieldRef of unknown type '" + fieldRef.getClass().getName() + "'");
    }

    @Override
    public void recalculate() {
        this.basicRecalculate(null);
    }

    @Override
    public void recalculate(Object fieldRef) {
        this.basicRecalculate(this.marshalField(fieldRef));
    }

    @Override
    public void resetFields() {
        this.doResetFields(this.getAcroForm().collectLeafFields());
    }

    @Override
    public void resetFields(List fieldNames, boolean invert) {
        ArrayList fields = null;
        if (invert) {
            fields = this.getAcroForm().collectLeafFields();
            for (String fieldName : fieldNames) {
                PDAcroFormField field = this.getAcroForm().getField(fieldName);
                if (field == null) continue;
                fields.removeAll(field.collectLeafFields());
            }
        } else {
            fields = new ArrayList();
            for (String fieldName : fieldNames) {
                PDAcroFormField field = this.getAcroForm().getField(fieldName);
                if (field == null) continue;
                fields.addAll(field.collectLeafFields());
            }
        }
        this.doResetFields(fields);
    }

    @Override
    public void setCalculate(boolean calculate) {
        this.calculate = calculate;
    }

    @Override
    public void setFieldValue(Object fieldRef, Object value) {
        if (value instanceof List) {
            this.basicSetFieldValue(this.marshalField(fieldRef), (List)value);
        } else if (value instanceof String) {
            this.basicSetFieldValue(this.marshalField(fieldRef), (String)value);
        } else if (value instanceof COSName) {
            this.basicSetFieldValue(this.marshalField(fieldRef), ((COSName)value).stringValue());
        } else if (value instanceof COSString) {
            this.basicSetFieldValue(this.marshalField(fieldRef), ((COSString)value).stringValue());
        } else if (value instanceof PDSignature) {
            this.basicSetFieldValue(this.marshalField(fieldRef), (PDSignature)value);
        } else if (value instanceof COSNull) {
            this.basicSetFieldValue(this.marshalField(fieldRef), (String)null);
        } else if (value == null) {
            this.basicSetFieldValue(this.marshalField(fieldRef), (String)null);
        } else {
            value = String.valueOf(value);
            this.basicSetFieldValue(this.marshalField(fieldRef), (String)value);
        }
    }

    @Override
    public void setValidate(boolean validate) {
        this.validate = validate;
    }
}

