/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content;

import de.intarsys.pdf.content.CSOperator;
import de.intarsys.pdf.content.CSOperators;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import java.util.Arrays;
import java.util.Iterator;

public class CSOperation {
    public static final COSName OPERAND_Tx = COSName.constant("Tx");
    private byte[] operatorToken;
    private COSObject[] operands;
    private Object cache;

    public CSOperation(byte[] operatorToken, COSObject[] operands) {
        this.operatorToken = operatorToken;
        this.operands = operands;
    }

    public CSOperation(CSOperator operator) {
        this(operator, new COSObject[0]);
    }

    public CSOperation(CSOperator operator, COSObject[] operands) {
        this.operatorToken = operator.getToken();
        this.operands = operands;
    }

    public void addOperand(COSObject object) {
        COSObject[] newOperands = new COSObject[this.operands.length + 1];
        System.arraycopy(this.operands, 0, newOperands, 0, this.operands.length);
        newOperands[newOperands.length - 1] = object;
        this.operands = newOperands;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CSOperation)) return false;
        CSOperation otherOperation = (CSOperation)other;
        if (!Arrays.deepEquals(this.operands, otherOperation.operands)) return false;
        if (!Arrays.equals(this.operatorToken, otherOperation.operatorToken)) return false;
        return true;
    }

    public Object getCache() {
        return this.cache;
    }

    public COSObject getOperand(int i) {
        return this.operands[i];
    }

    public Iterator<COSObject> getOperands() {
        return Arrays.asList(this.operands).iterator();
    }

    public CSOperator getOperator() {
        return new CSOperator(this.operatorToken);
    }

    public byte[] getOperatorToken() {
        return this.operatorToken;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.operands);
        result = 31 * result + Arrays.hashCode(this.operatorToken);
        return result;
    }

    public boolean hasOperator() {
        return this.operatorToken != null;
    }

    public boolean isOpBeginMarkedContent(COSName mark) {
        if (this.matchesOperator(CSOperators.CSO_BMC)) {
            if (mark == null || this.operandSize() == 0) {
                return true;
            }
            COSObject operand = this.getOperand(0);
            if (operand instanceof COSName && operand.equals(mark)) {
                return true;
            }
        }
        return false;
    }

    public boolean isOpEndMarkedContent() {
        return this.matchesOperator(CSOperators.CSO_EMC);
    }

    public boolean matchesOperator(CSOperator other) {
        return Arrays.equals(this.operatorToken, other.getToken());
    }

    public int operandSize() {
        return this.operands.length;
    }

    public void setCache(Object cache) {
        this.cache = cache;
    }

    public COSObject setOperand(int i, COSObject object) {
        COSObject old = this.operands[i];
        this.operands[i] = object;
        return old;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (COSObject operand : this.operands) {
            sb.append(operand).append(' ');
        }
        if (this.operatorToken == null) {
            sb.append("null");
        } else {
            sb.append(new String(this.operatorToken));
        }
        return sb.toString();
    }
}

