/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content.common;

import de.intarsys.pdf.content.CSBasicDevice;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.tools.geometry.GeometryTools;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class CSBoundingBoxCollector
extends CSBasicDevice {
    private Rectangle2D boundingBox;

    protected void addBoundingBox(Rectangle2D rect, boolean addLineWidth) {
        GeometryTools.normalizeRect((Rectangle2D)rect);
        if (addLineWidth) {
            double factor = this.graphicsState.transform.getScaleX();
            factor = Math.max(this.graphicsState.transform.getScaleY(), factor);
            double border = (double)this.graphicsState.lineWidth * factor + 5.0;
            rect.add(rect.getMinX() - border, rect.getMinY() - border);
            rect.add(rect.getMaxX() + border, rect.getMaxY() + border);
        }
        if (this.graphicsState.clip != null) {
            Area rectArea = new Area(rect);
            Area tempArea = new Area(this.graphicsState.clip);
            rectArea.intersect(tempArea);
            if (rectArea.isEmpty()) {
                return;
            }
            rect = rectArea.getBounds2D();
        }
        if (this.boundingBox == null) {
            this.boundingBox = (Rectangle2D)rect.clone();
        } else {
            this.boundingBox.add(rect);
        }
    }

    @Override
    protected void basicDraw(Shape shape) {
        Area area = new Area(shape.getBounds2D());
        area.transform(this.graphicsState.transform);
        this.addBoundingBox(area.getBounds2D(), true);
    }

    @Override
    protected void basicFill(Shape shape) {
        Area area = new Area(shape.getBounds2D());
        area.transform(this.graphicsState.transform);
        this.addBoundingBox(area.getBounds2D(), true);
    }

    @Override
    protected void basicTextShowGlyphs(PDGlyphs glyphs, float advance) throws CSException {
        double factor = this.textState.fontSize / 1000.0f;
        float x = 0.0f;
        float y = (float)(glyphs.getDescent() * factor);
        float width = (float)((double)glyphs.getWidth() * factor);
        float height = (float)(glyphs.getAscent() * factor);
        Rectangle2D.Float rect = new Rectangle2D.Float(x, y, width, height);
        Area area = new Area(rect);
        area.transform(this.textState.globalTransform);
        this.addBoundingBox(area.getBounds2D(), true);
        super.basicTextShowGlyphs(glyphs, advance);
    }

    @Override
    protected void doImage(COSName name, PDImage image) throws CSException {
        Area area = new Area(new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f));
        area.transform(this.graphicsState.transform);
        this.addBoundingBox(area.getBounds2D(), false);
    }

    public Rectangle2D getBoundingBox() {
        return this.boundingBox;
    }
}

