/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content.text;

import de.intarsys.pdf.content.ICSInterpreter;
import de.intarsys.pdf.content.text.CSCharacterParser;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.tools.string.StringTools;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class CSTextExtractor
extends CSCharacterParser {
    private StringBuilder content;
    private double maxDX = 5.0;
    private double maxDY = 5.0;

    private void append(char[] chars) {
        this.content.append(chars);
    }

    private void append(String s) {
        this.content.append(s);
    }

    public String getContent() {
        return this.content.toString();
    }

    @Override
    protected void onCharacterFound(PDGlyphs glyphs, Rectangle2D rect) {
        char[] chars = glyphs.getChars();
        if (chars == null) {
            chars = new char[]{' '};
        }
        double dX = this.lastStopX - this.lastStartX;
        double dY = this.lastStopY - this.lastStartY;
        if (Math.abs(dX) < this.maxDX) {
            if (Math.abs(dY) > this.maxDY && this.content.length() > 0) {
                this.append(StringTools.LS);
            }
        } else if (this.content.length() > 0) {
            if (Math.abs(dY) < this.maxDY) {
                this.append(" ");
            } else {
                this.append(StringTools.LS);
            }
        }
        this.append(chars);
    }

    @Override
    public void open(ICSInterpreter pInterpreter) {
        super.open(pInterpreter);
        this.content = new StringBuilder();
    }

    @Override
    public void textSetFont(COSName name, PDFont font, float size) {
        super.textSetFont(name, font, size);
        AffineTransform tx = (AffineTransform)this.getDeviceTransform().clone();
        tx.concatenate(this.textState.globalTransform);
        this.maxDX = (double)this.textState.fontSize * 0.2 * tx.getScaleX();
        this.maxDY = (double)this.textState.fontSize * 0.6 * tx.getScaleY();
    }

    @Override
    public void textSetTransform(float a, float b, float c, float d, float e, float f) {
        super.textSetTransform(a, b, c, d, e, f);
        AffineTransform tx = (AffineTransform)this.getDeviceTransform().clone();
        tx.concatenate(this.textState.globalTransform);
        this.maxDX = (double)this.textState.fontSize * 0.2 * tx.getScaleX();
        this.maxDY = (double)this.textState.fontSize * 0.6 * tx.getScaleY();
    }
}

