/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.crypt.AbstractCryptHandler;
import de.intarsys.pdf.crypt.COSSecurityException;
import java.security.MessageDigest;
import javax.crypto.Cipher;

public abstract class StandardCryptHandler
extends AbstractCryptHandler {
    protected Cipher cipher;
    protected MessageDigest md;
    private byte[] generationBytes = new byte[2];
    private byte[] objectBytes = new byte[3];
    private byte[] cryptKey;
    protected int length;

    protected StandardCryptHandler() {
    }

    protected abstract byte[] basicDecrypt(byte[] var1, byte[] var2, int var3, int var4) throws COSSecurityException;

    protected abstract byte[] basicEncrypt(byte[] var1, byte[] var2, int var3, int var4) throws COSSecurityException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decrypt(COSObjectKey objectKey, byte[] bytes) throws COSSecurityException {
        if (bytes == null) {
            return null;
        }
        if (objectKey == null) {
            return bytes;
        }
        StandardCryptHandler standardCryptHandler = this;
        synchronized (standardCryptHandler) {
            return this.basicDecrypt(bytes, this.getCryptKey(), objectKey.getObjectNumber(), objectKey.getGenerationNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encrypt(COSObjectKey objectKey, byte[] bytes) throws COSSecurityException {
        if (bytes == null) {
            return null;
        }
        if (objectKey == null) {
            return bytes;
        }
        StandardCryptHandler standardCryptHandler = this;
        synchronized (standardCryptHandler) {
            return this.basicEncrypt(bytes, this.getCryptKey(), objectKey.getObjectNumber(), objectKey.getGenerationNumber());
        }
    }

    protected byte[] getCryptKey() {
        return this.cryptKey;
    }

    public void initialize(byte[] pCryptKey) throws COSSecurityException {
        this.cryptKey = pCryptKey;
        this.length = this.cryptKey.length + 5;
        if (this.length > 16) {
            this.length = 16;
        }
    }

    protected void updateHash(byte[] encryptionKey, int objectNum, int genNum) {
        this.md.reset();
        this.md.update(encryptionKey);
        this.objectBytes[0] = (byte)(objectNum & 0xFF);
        this.objectBytes[1] = (byte)((objectNum >>= 8) & 0xFF);
        this.objectBytes[2] = (byte)((objectNum >>= 8) & 0xFF);
        this.md.update(this.objectBytes);
        this.generationBytes[0] = (byte)(genNum & 0xFF);
        this.generationBytes[1] = (byte)((genNum >>= 8) & 0xFF);
        this.md.update(this.generationBytes);
    }
}

