/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.AcroFormSigFlags;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.pdf.pd.PDSignatureLock;
import de.intarsys.pdf.pd.PDSignatureSeedValue;
import java.util.HashSet;

public class PDAFSignatureField
extends PDAcroFormField {
    public static final COSName DK_Lock = COSName.constant("Lock");
    public static final COSName DK_SV = COSName.constant("SV");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private PDSignature cachedSignature;

    protected PDAFSignatureField(COSObject object) {
        super(object);
    }

    public void clearSignature() {
        COSDictionary perms = this.getDoc().cosGetPermissionsDict();
        if (perms != null) {
            for (COSName key : new HashSet(perms.keySet())) {
                COSObject value = perms.get(key);
                if (value != this.cosGetValue()) continue;
                perms.remove(key);
            }
        }
        this.setSignature(null);
    }

    @Override
    public COSName cosGetExpectedFieldType() {
        return CN_FT_Sig;
    }

    @Override
    public COSObject cosSetValue(COSObject newValue) {
        COSObject result = super.cosSetValue(newValue);
        AcroFormSigFlags sigFlags = this.getAcroForm().getSigFlags();
        sigFlags.setAppendOnly(this.getAcroForm().isSigned());
        return result;
    }

    public PDSignatureLock getLock() {
        return (PDSignatureLock)PDSignatureLock.META.createFromCos(this.cosGetField(DK_Lock));
    }

    public PDSignatureSeedValue getSeedValue() {
        return (PDSignatureSeedValue)PDSignatureSeedValue.META.createFromCos(this.cosGetField(DK_SV));
    }

    public PDSignature getSignature() {
        if (this.cachedSignature == null) {
            this.cachedSignature = (PDSignature)PDSignature.META.createFromCos(this.cosGetValue());
            if (this.cachedSignature != null) {
                this.cachedSignature.setAcroFormField(this);
            }
        }
        return this.cachedSignature;
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedSignature = null;
    }

    public boolean isSigned() {
        return !this.cosGetValue().isNull();
    }

    @Override
    public boolean isTypeSig() {
        return true;
    }

    public void setLock(PDSignatureLock lock) {
        this.setFieldObject(DK_Lock, lock);
    }

    public void setSeedValue(PDSignatureSeedValue value) {
        this.setFieldObject(DK_SV, value);
    }

    public void setSignature(PDSignature newSignature) {
        if (this.cachedSignature != null) {
            this.cachedSignature.setAcroFormField(null);
        }
        this.cachedSignature = newSignature;
        if (newSignature != null) {
            newSignature.setAcroFormField(this);
            this.cosSetValue(newSignature.cosGetObject());
        } else {
            this.cosSetValue(null);
        }
    }

    public static class MetaClass
    extends PDAcroFormField.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDAFSignatureField(object);
        }
    }
}

