/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDResources;

public class PDTilingPattern
extends PDPattern
implements IContentStreamProvider {
    public static final COSName DK_PaintType = COSName.constant("PaintType");
    public static final COSName DK_BBox = COSName.constant("BBox");
    public static final COSName DK_Resources = COSName.constant("Resources");
    public static final COSName DK_XStep = COSName.constant("XStep");
    public static final COSName DK_YStep = COSName.constant("YStep");
    public static final COSName DK_TilingType = COSName.constant("TilingType");
    public static final int PAINT_TYPE_COLORED = 1;
    public static final int PAINT_TYPE_UNCOLORED = 2;
    public static final int TILING_TYPE_CONSTANT_SPACING = 1;
    public static final int TILING_TYPE_NO_DISTORTION = 2;
    public static final int TILING_TYPE_CONSTANT_SPACING_AND_FASTER_TILING = 3;
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private CSContent cachedContent;

    protected PDTilingPattern(COSObject object) {
        super(object);
    }

    @Override
    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.setFieldInt(DK_PatternType, 1);
        this.setPaintType(1);
        this.setTilingType(1);
        this.setBoundingBox(new CDSRectangle());
        this.cosSetField(DK_Resources, COSDictionary.create());
        this.setBytes(new byte[0]);
    }

    @Override
    public COSDictionary cosGetDict() {
        return this.cosGetStream().getDict();
    }

    @Override
    public int getPatternType() {
        return 1;
    }

    public int getPaintType() {
        return this.getFieldInt(DK_PaintType, 1);
    }

    public void setPaintType(int paintType) {
        this.setFieldInt(DK_PaintType, paintType);
    }

    public int getTilingType() {
        return this.getFieldInt(DK_TilingType, 1);
    }

    public void setTilingType(int tilingType) {
        this.setFieldInt(DK_TilingType, tilingType);
    }

    public float getXStep() {
        return this.getFieldFixed(DK_XStep, 1.0f);
    }

    public void setXStep(float step) {
        this.setFieldFixed(DK_XStep, step);
    }

    public float getYStep() {
        return this.getFieldFixed(DK_YStep, 1.0f);
    }

    public void setYStep(float step) {
        this.setFieldFixed(DK_YStep, step);
    }

    public CDSRectangle getBoundingBox() {
        COSArray array = this.cosGetField(DK_BBox).asArray();
        if (array == null) {
            return null;
        }
        return CDSRectangle.createFromCOS(array);
    }

    public void setBoundingBox(CDSRectangle rect) {
        this.setFieldObject(DK_BBox, rect);
    }

    @Override
    public CSContent getContentStream() {
        if (this.cachedContent == null) {
            this.cachedContent = CSContent.createFromCos(this.cosGetStream());
        }
        return this.cachedContent;
    }

    @Override
    public void setContentStream(CSContent content) {
        this.setBytes(content.toByteArray());
    }

    public void setBytes(byte[] bytes) {
        this.cosGetStream().setDecodedBytes(bytes);
    }

    @Override
    public PDResources getResources() {
        COSDictionary r = this.cosGetField(DK_Resources).asDictionary();
        return (PDResources)PDResources.META.createFromCos(r);
    }

    @Override
    public void setResources(PDResources resources) {
        this.setFieldObject(DK_Resources, resources);
    }

    public static class MetaClass
    extends PDPattern.MetaClass {
        protected MetaClass(Class<?> paramInstanceClass) {
            super(paramInstanceClass);
        }

        @Override
        protected COSObject doCreateCOSObject() {
            return COSStream.create(null);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDTilingPattern(object);
        }
    }
}

