/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.PDObject;

public class PDVRI
extends PDObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName CN_Type_VRI = COSName.constant("VRI");
    public static final COSName DK_Certs = COSName.constant("Certs");
    public static final COSName DK_OCSPs = COSName.constant("OCSPs");
    public static final COSName DK_CRLs = COSName.constant("CRLs");
    public static final COSName DK_TU = COSName.constant("TU");
    public static final COSName DK_TS = COSName.constant("TS");

    protected PDVRI(COSObject object) {
        super(object);
    }

    public void addCert(COSStream data) {
        this.addStream(DK_Certs, data);
    }

    public void addCRL(COSStream data) {
        this.addStream(DK_CRLs, data);
    }

    public void addOCSP(COSStream data) {
        this.addStream(DK_OCSPs, data);
    }

    protected void addStream(COSName key, COSStream data) {
        COSArray array = this.cosGetField(key).asArray();
        if (array == null) {
            array = COSArray.create();
            this.cosSetField(key, array);
        }
        array.add(data);
    }

    protected byte[][] collectStreams(COSName key) {
        COSArray array = this.cosGetField(key).asArray();
        if (array == null) {
            return new byte[0][];
        }
        byte[][] result = new byte[array.size()][];
        for (int i = 0; i < array.size(); ++i) {
            COSStream stream = array.get(i).asStream();
            result[i] = stream.getDecodedBytes();
        }
        return result;
    }

    @Override
    protected COSName cosGetExpectedType() {
        return CN_Type_VRI;
    }

    public byte[][] getCerts() {
        return this.collectStreams(DK_Certs);
    }

    public byte[][] getCRLs() {
        return this.collectStreams(DK_CRLs);
    }

    public byte[][] getOCSPs() {
        return this.collectStreams(DK_OCSPs);
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDVRI(object);
        }
    }
}

