/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.tools.kernel;

import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.locator.URLLocator;
import de.intarsys.tools.system.SystemTools;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class PDFFileTools {
    private static final String BACKSLASH = "\\";
    private static final String DOUBLE_BACKSLASH = "\\\\";

    public static ILocator resolveLocator(ILocator baseLocator, String osIndependentPath) throws IOException {
        if (osIndependentPath.contains("://")) {
            return new URLLocator(new URL(osIndependentPath));
        }
        String result = PDFFileTools.toOSPath(osIndependentPath);
        if (baseLocator == null) {
            return LocatorFactory.get().createLocator(result);
        }
        if (result.startsWith(BACKSLASH) && !result.startsWith(DOUBLE_BACKSLASH)) {
            return LocatorTools.getRoot((ILocator)baseLocator).getChild(result);
        }
        File resultFile = new File(result);
        if (resultFile.isAbsolute()) {
            return LocatorFactory.get().createLocator(result);
        }
        return baseLocator.getChild(result);
    }

    public static ILocator resolveLocator(ILocatorFactory locatorFactory, String osIndependentPath) throws IOException {
        if (osIndependentPath.contains("://")) {
            return new URLLocator(new URL(osIndependentPath));
        }
        String result = PDFFileTools.toOSPath(osIndependentPath);
        if (locatorFactory == null) {
            return LocatorFactory.get().createLocator(result);
        }
        if (result.startsWith(BACKSLASH) && !result.startsWith(DOUBLE_BACKSLASH)) {
            ILocator tempRoot = LocatorTools.getRoot((ILocator)locatorFactory.createLocator(result));
            return tempRoot.getChild(result);
        }
        File resultFile = new File(result);
        if (resultFile.isAbsolute()) {
            return LocatorFactory.get().createLocator(result);
        }
        return locatorFactory.createLocator(result);
    }

    public static String toOSIndependentPath(String osPath) {
        if (SystemTools.isWindows()) {
            return PDFFileTools.windowsToOSIndependentPath(osPath);
        }
        return osPath;
    }

    public static String toOSPath(String osIndependentPath) {
        if (SystemTools.isWindows()) {
            return PDFFileTools.toWindowsPath(osIndependentPath);
        }
        return osIndependentPath;
    }

    protected static String toWindowsPath(String osIndependentPath) {
        if (File.separatorChar == '/') {
            return osIndependentPath;
        }
        if (osIndependentPath.startsWith("///")) {
            return DOUBLE_BACKSLASH + osIndependentPath.substring(3).replace("/", BACKSLASH);
        }
        if (osIndependentPath.startsWith("//")) {
            return BACKSLASH + osIndependentPath.substring(2).replace("/", BACKSLASH);
        }
        if (osIndependentPath.startsWith("/")) {
            File drive;
            Object windows = osIndependentPath.substring(1).replace("/", BACKSLASH);
            int index = ((String)windows).indexOf(BACKSLASH);
            if (index < 0) {
                index = ((String)windows).length();
            }
            windows = (drive = new File(((String)windows).substring(0, index) + ":")).isDirectory() ? ((String)windows).substring(0, index) + ":" + ((String)windows).substring(index) : DOUBLE_BACKSLASH + (String)windows;
            return windows;
        }
        return osIndependentPath.replace("/", BACKSLASH);
    }

    protected static String windowsToOSIndependentPath(String osPath) {
        Object osIndependentPath = osPath.replace(BACKSLASH, "/");
        int index = ((String)osIndependentPath).indexOf(":");
        if (index >= 0 && index < ((String)osIndependentPath).indexOf("/")) {
            osIndependentPath = "/" + ((String)osIndependentPath).substring(0, index) + ((String)osIndependentPath).substring(index + 1);
        }
        return osIndependentPath;
    }

    private PDFFileTools() {
    }
}

