/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import de.intarsys.tools.string.ConverterException;
import java.io.IOException;
import java.util.Map;

public final class JsonTools {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static Map<String, Object> asMap(String string) throws ConverterException {
        ObjectReader reader = MAPPER.readerFor(Map.class);
        try {
            return (Map)reader.readValue(string);
        }
        catch (IOException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    private JsonTools() {
    }

    static {
        MAPPER.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
        MAPPER.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_TRAILING_COMMA});
        MAPPER.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES});
    }
}

