/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorContentSerializer
extends StdSerializer<ILocator> {
    private static final Logger Log = LoggerFactory.getLogger(LocatorContentSerializer.class);

    public LocatorContentSerializer() {
        super(ILocator.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(ILocator locator, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (locator == null) {
            provider.defaultSerializeNull(gen);
            return;
        }
        gen.writeStartObject();
        provider.defaultSerializeField("name", (Object)locator.getName(), gen);
        gen.writeFieldName("content");
        InputStream is = locator.getInputStream();
        try {
            gen.writeBinary(is, -1);
            Log.debug("{} serialized {} with {} bytes", new Object[]{((Object)((Object)this)).getClass(), locator.getName(), locator.getLength()});
        }
        finally {
            StreamTools.close((Closeable)is);
        }
        gen.writeEndObject();
    }
}

