/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

public class TypedSerializer
extends StdSerializer<Object> {
    public TypedSerializer() {
        super(Object.class);
    }

    protected boolean isPrimitive(Object object) {
        return object instanceof Number || object instanceof Boolean || object instanceof String;
    }

    public void serialize(Object object, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (object == null) {
            provider.defaultSerializeNull(gen);
            return;
        }
        gen.writeStartObject();
        provider.defaultSerializeField("@class", object.getClass(), gen);
        provider.defaultSerializeField("value", object, gen);
        gen.writeEndObject();
    }
}

