/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.aaa.authenticate.module.composite;

import de.intarsys.aaa.authenticate.api.IAuthenticationContext;
import de.intarsys.aaa.authenticate.api.IAuthenticationEvidence;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationContext;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationModule;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationState;
import de.intarsys.aaa.authenticate.module.composite.CompositeAuthenticationModule;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.functor.IArgs;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;

public class CompositeAuthenticationContext
extends CommonAuthenticationContext {
    private final List<IAuthenticationContext> authenticationContexts = new ArrayList<IAuthenticationContext>();

    public CompositeAuthenticationContext(CommonAuthenticationModule authenticationModule, Subject subject) {
        super(authenticationModule, subject);
    }

    protected void addAuthenticationContext(IAuthenticationContext context) {
        this.authenticationContexts.add(context);
    }

    @Override
    protected IConversation<CommonAuthenticationState> basicAuthenticate(IArgs authenticationArgs) {
        IConversation conversation = Conversation.completed(null);
        for (IAuthenticationContext context : this.getAuthenticationContexts()) {
            conversation = conversation.thenCompose(result -> {
                IConversation<Void> moduleConversation = context.authenticate(authenticationArgs);
                return moduleConversation.thenApply(ignore -> null);
            });
        }
        return conversation;
    }

    @Override
    protected void basicDeauthenticate() {
        for (IAuthenticationContext context : this.getAuthenticationContexts()) {
            context.deauthenticate();
        }
        super.basicDeauthenticate();
    }

    @Override
    protected IAuthenticationEvidence createAuthenticationEvidence(CommonAuthenticationState authenticationState) {
        return null;
    }

    public List<IAuthenticationContext> getAuthenticationContexts() {
        return this.authenticationContexts;
    }

    @Override
    public CompositeAuthenticationModule getAuthenticationModule() {
        return (CompositeAuthenticationModule)super.getAuthenticationModule();
    }
}

