/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.aaa.authorization.impl;

import de.intarsys.aaa.authorization.api.AuthorizationException;
import de.intarsys.aaa.authorization.api.IAuthorizationStrategy;
import de.intarsys.aaa.resource.IOperation;
import de.intarsys.aaa.resource.IResource;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.LiteralMessage;
import de.intarsys.tools.observation.api.Observation;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonAuthorizationStrategy
implements IAuthorizationStrategy {
    private static final Logger Log = LoggerFactory.getLogger(CommonAuthorizationStrategy.class);

    @Override
    public final void checkAccess(IResource resource, IOperation operation) throws AuthorizationException {
        this.hookCheckAccessBefore(resource, operation);
        try {
            this.hookCheckAccess(resource, operation);
            this.hookCheckAccessSuccess(resource, operation);
        }
        catch (AuthorizationException e) {
            this.hookCheckAccessFailed(resource, operation);
            throw e;
        }
    }

    protected void hookCheckAccess(IResource resource, IOperation operation) throws AuthorizationException {
    }

    protected void hookCheckAccessBefore(IResource resource, IOperation operation) throws AuthorizationException {
    }

    protected void hookCheckAccessFailed(IResource resource, IOperation operation) throws AuthorizationException {
        IMessage msg = LiteralMessage.create((String)"failed", (String)"authorization failed", (Object[])new Object[0]);
        Observation.builder().source("authorization").put("resourceType", (Object)resource.getType()).put("resourceId", (Object)resource.getId()).put("operationId", (Object)(operation == null ? null : operation.getId())).message(msg).build().publish();
    }

    protected void hookCheckAccessSuccess(IResource resource, IOperation operation) throws AuthorizationException {
        IMessage msg = LiteralMessage.create((String)"success", (String)"authorization success", (Object[])new Object[0]);
        Observation.builder().source("authorization").put("resourceType", (Object)resource.getType()).put("resourceId", (Object)resource.getId()).put("operationId", (Object)(operation == null ? null : operation.getId())).message(msg).build().publish();
    }

    @PostConstruct
    public void init() {
        Log.info("authorization strategy {} installed", (Object)this.getClass().getName());
    }
}

