/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.aaa.authorization.impl;

import de.intarsys.aaa.authorization.api.AccessDenied;
import de.intarsys.aaa.authorization.api.AuthorizationException;
import de.intarsys.aaa.authorization.api.IAuthorizationStrategy;
import de.intarsys.aaa.authorization.impl.CommonAuthorizationStrategy;
import de.intarsys.aaa.resource.IOperation;
import de.intarsys.aaa.resource.IResource;

public class OrAuthorization
extends CommonAuthorizationStrategy {
    private final IAuthorizationStrategy[] operands;

    public OrAuthorization(IAuthorizationStrategy ... operands) {
        this.operands = operands;
    }

    @Override
    protected void hookCheckAccess(IResource resource, IOperation operation) throws AuthorizationException {
        AuthorizationException ex = null;
        for (IAuthorizationStrategy operand : this.operands) {
            try {
                operand.checkAccess(resource, operation);
                return;
            }
            catch (AuthorizationException e) {
                ex = e;
            }
        }
        throw ex == null ? new AccessDenied() : ex;
    }
}

