/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.aaa.resource;

import de.intarsys.aaa.resource.Resource;
import de.intarsys.tools.component.IIdentifiable;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.string.StringTools;
import java.util.Objects;

public class SimpleObjectResource
extends Resource
implements IPresentationSupport {
    private final String type;
    private final String id;
    private String label;

    public static SimpleObjectResource createFromClass(Class clazz) {
        return new SimpleObjectResource(clazz.getName(), null);
    }

    public static SimpleObjectResource createFromClass(Class clazz, String id) {
        return new SimpleObjectResource(clazz.getName(), id);
    }

    public static SimpleObjectResource createFromIdentifiable(IIdentifiable value) {
        return new SimpleObjectResource(value.getClass().getName(), value.getId());
    }

    public static SimpleObjectResource createFromString(String type, String id) {
        return new SimpleObjectResource(type, id);
    }

    public static SimpleObjectResource parse(String value) {
        if (value == null) {
            return null;
        }
        int index = value.indexOf(":");
        String type = value;
        String id = null;
        if (index == 0) {
            throw new IllegalArgumentException("resource cannot start with ':' (" + value + ")");
        }
        if (index > 0) {
            id = value.substring(index + 1);
            type = value.substring(0, index);
        }
        return new SimpleObjectResource(type, id);
    }

    protected SimpleObjectResource(String type, String id) {
        this.type = type;
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleObjectResource)) {
            return false;
        }
        return LangTools.equals((Object)((SimpleObjectResource)obj).type, (Object)this.type) && LangTools.equals((Object)((SimpleObjectResource)obj).id, (Object)this.id);
    }

    public String getDescription() {
        return this.getTip();
    }

    public String getIconName() {
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTip() {
        return this.getLabel();
    }

    @Override
    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        if (StringTools.isEmpty((String)this.getId())) {
            return this.getType();
        }
        return this.getType() + ":" + this.getId();
    }
}

