/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.validation;

import de.intarsys.security.document.validation.IDocumentStateRule;
import de.intarsys.security.document.validation.ISignedDocument;
import de.intarsys.security.document.validation.IVSDocument;
import de.intarsys.security.document.validation.PACKAGE;
import de.intarsys.security.document.validation.VSDocument;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.security.validation.IVSSignatureContainerEntry;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.node.IStateNode;
import de.intarsys.security.validation.node.StateNodeTools;
import de.intarsys.tools.message.IMessageBundle;
import java.util.Date;
import java.util.List;

public class ReferenceSignatureRule
implements IDocumentStateRule {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    @Override
    public IVSDocument createState(ISignedDocument signedDocument) {
        VSDocument state = VSDocument.create(signedDocument);
        this.updateTargetState(state);
        return state;
    }

    protected IValidationState getReferenceState(IVSDocument signedDocumentState) {
        IVSSignatureContainerEntry latest = null;
        Date latestDate = null;
        IVSSignatureContainerEntry best = null;
        for (IVSSignatureContainer containerState : signedDocumentState.getSignatureContainerStates()) {
            List entryStates = containerState.getEntryStates();
            if (entryStates == null) continue;
            for (IVSSignatureContainerEntry entryState : entryStates) {
                Date entryDate = entryState.getCreationDate();
                if (entryDate != null && (latestDate == null || latestDate.before(entryDate))) {
                    latestDate = entryDate;
                    latest = entryState;
                }
                if (entryState.isUndefined() || best != null && entryState.getState() >= best.getState()) continue;
                best = entryState;
            }
        }
        if (latest != null) {
            return latest;
        }
        return best;
    }

    protected void updateTargetState(VSDocument signedDocumentState) {
        IValidationState state = this.getReferenceState(signedDocumentState);
        if (state == null) {
            signedDocumentState.setRecoverable(false);
            signedDocumentState.increaseState(2);
        } else {
            IStateNode node;
            signedDocumentState.setRecoverable(true);
            signedDocumentState.increaseState(state.getState());
            if (state.isValid() && (node = StateNodeTools.createNode(signedDocumentState)).hasWarnings()) {
                signedDocumentState.addMessage(ValidationMessage.createError((String)Msg.getString("SignedDocument.errorReferenceSignatureHasWarnings", new Object[0])));
            }
        }
    }
}

