/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.validation;

import de.intarsys.document.common.CommonDocument;
import de.intarsys.document.model.IDocument;
import de.intarsys.security.document.validation.AllSignaturesValidRule;
import de.intarsys.security.document.validation.IDocumentStateRule;
import de.intarsys.security.document.validation.ISignedDocument;
import de.intarsys.security.document.validation.IVSDocument;
import de.intarsys.security.document.validation.PACKAGE;
import de.intarsys.security.document.validation.ReferenceSignatureRule;
import de.intarsys.security.document.validation.UnknownStateRule;
import de.intarsys.security.processor.validation.SignatureContainerTools;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.standard.validation.VSSignatureContainer;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.security.validation.ValidationEnvironment;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.collection.IterableTools;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.DestroyedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.event.wrapper.AttributeChangeListener;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locking.ILock;
import de.intarsys.tools.locking.ILockLevel;
import de.intarsys.tools.locking.ILockSupport;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.streaming.StreamingTools;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedDocument
implements ISignedDocument {
    public static final String METHOD_CONTAINER_VALIDATE = "validate";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(SignedDocument.class);
    private static final Attribute ATTR_SIGNEDDOCUMENT = new Attribute("signedDocument");
    private static final Attribute ATTR_LOCK = new Attribute("LOCK");
    private static final Attribute ATTR_LISTENER_CHANGE_LOCATOR = new Attribute("listenerChangeLocator");
    public static final String ARG_DOCUMENT_STATE_RULE = "documentStateRule";
    public static final String ARG_VALIDATION_TIMEOUT = "validationTimeout";
    public static final String DOCUMENT_STATE_RULE_MOSTRECENTSIGNATURE = "mostRecentSignature";
    public static final String DOCUMENT_STATE_RULE_ALLVALLID = "allValid";
    private final Object VALIDATION_LOCK = new Object();
    private final EventDispatcher dispatcher;
    private final IDocument document;
    private IDocumentStateRule documentStateRule;
    private final INotificationListener listenDocumentDestroyed = new INotificationListener(){

        public void handleEvent(Event event) {
            SignedDocument.this.detach();
        }
    };
    private final INotificationListener listenDocumentAttributeChanged = new INotificationListener(){

        public void handleEvent(Event event) {
            SignedDocument.this.onDocumentAttributeChanged((AttributeChangedEvent)event);
        }
    };
    private final List<ISignatureContainer> signatureContainers;
    private boolean licenseRestricted;

    protected static ISignedDocument create(IDocument document, IArgs args) {
        SignedDocument signedDocument = new SignedDocument(document);
        signedDocument.init(args);
        return signedDocument;
    }

    public static synchronized ISignedDocument getSignedDocument(IDocument document) {
        return SignedDocument.getSignedDocument(document, (IArgs)Args.create());
    }

    public static synchronized ISignedDocument getSignedDocument(IDocument document, IArgs args) {
        ISignedDocument signedDoc = (ISignedDocument)document.getAttribute((Object)ATTR_SIGNEDDOCUMENT);
        if (signedDoc == null) {
            signedDoc = SignedDocument.create(document, args);
            SignedDocument.setSignedDocument((IAttributeSupport)document, signedDoc);
        }
        return signedDoc;
    }

    protected static void lock(final ISignatureContainer signatureContainer) {
        ILockSupport lockSupport = (ILockSupport)AdapterTools.getAdapter((Object)signatureContainer.getLocator(), ILockSupport.class, null);
        if (lockSupport != null) {
            try {
                ILock lock = lockSupport.getLock();
                lock.acquire((Object)signatureContainer, ILockLevel.SHARED);
                signatureContainer.setAttribute((Object)ATTR_LOCK, (Object)lock);
            }
            catch (Exception lock) {
                // empty catch block
            }
        }
        if (signatureContainer instanceof INotificationSupport) {
            AttributeChangeListener listenLocatorChanged = new AttributeChangeListener("locator"){

                public void handleAttributeChange(AttributeChangedEvent event) {
                    SignedDocument.unlock(signatureContainer);
                    SignedDocument.lock(signatureContainer);
                }
            };
            ((INotificationSupport)signatureContainer).addNotificationListener(AttributeChangedEvent.ID, (INotificationListener)listenLocatorChanged);
            signatureContainer.setAttribute((Object)ATTR_LISTENER_CHANGE_LOCATOR, (Object)listenLocatorChanged);
        }
    }

    public static ISignedDocument lookupSignedDocument(IAttributeSupport attributeSupport) {
        return (ISignedDocument)attributeSupport.getAttribute((Object)ATTR_SIGNEDDOCUMENT);
    }

    protected static void setSignedDocument(IAttributeSupport attributeSupport, ISignedDocument signedDoc) {
        attributeSupport.setAttribute((Object)ATTR_SIGNEDDOCUMENT, (Object)signedDoc);
    }

    protected static void unlock(ISignatureContainer signatureContainer) {
        ILock lock = (ILock)signatureContainer.getAttribute((Object)ATTR_LOCK);
        if (lock == null) {
            return;
        }
        lock.release((Object)signatureContainer);
        signatureContainer.removeAttribute((Object)ATTR_LOCK);
        INotificationListener listenLocatorChanged = (INotificationListener)signatureContainer.getAttribute((Object)ATTR_LISTENER_CHANGE_LOCATOR);
        if (listenLocatorChanged != null) {
            ((INotificationSupport)signatureContainer).removeNotificationListener(AttributeChangedEvent.ID, listenLocatorChanged);
            signatureContainer.removeAttribute((Object)ATTR_LISTENER_CHANGE_LOCATOR);
        }
    }

    private SignedDocument(IDocument document) {
        this.document = document;
        this.dispatcher = new EventDispatcher((Object)this);
        this.signatureContainers = new ArrayList<ISignatureContainer>(3);
        this.initialize();
    }

    @Override
    public void addChangeEventListener(INotificationListener listener) {
        this.dispatcher.addNotificationListener(ChangeEvent.ID, listener);
    }

    @Override
    public void addSignatureContainer(ISignatureContainer container) {
        if (this.signatureContainers.contains(container)) {
            return;
        }
        ISignatureContainer previous = this.lookupContainer(container.getLocator());
        if (previous != null) {
            this.basicRemoveSignatureContainer(previous);
        }
        this.basicAddSignatureContainer(container);
        this.triggerChangeEvent();
    }

    private synchronized void basicAddSignatureContainer(ISignatureContainer container) {
        SignedDocument.lock(container);
        this.signatureContainers.add(container);
        SignedDocument.setSignedDocument((IAttributeSupport)container, this);
    }

    private synchronized void basicRemoveSignatureContainer(ISignatureContainer container) {
        this.signatureContainers.remove(container);
        SignedDocument.setSignedDocument((IAttributeSupport)container, null);
        SignedDocument.unlock(container);
    }

    /*
     * Exception decompiling
     */
    protected void basicValidate(IArgs args, boolean restricted) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 13[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public synchronized Iterator<ISignatureContainer> containerIterator() {
        return this.containers().iterator();
    }

    @Override
    public Stream<ISignatureContainer> containers() {
        return StreamingTools.copyStream(this.signatureContainers);
    }

    @Override
    public Iterator<IVSSignatureContainer> containerStateIterator() {
        return this.containerStates().iterator();
    }

    @Override
    public Stream<IVSSignatureContainer> containerStates() {
        return this.containers().map(container -> {
            IVSSignatureContainer state = VSSignatureContainer.getSignatureContainerState((ISignatureContainer)container);
            if (state == null) {
                state = new VSSignatureContainer(container);
            }
            return state;
        });
    }

    @Override
    public void detach() {
        this.document.removeAttribute((Object)ATTR_SIGNEDDOCUMENT);
        this.document.removeNotificationListener(DestroyedEvent.ID, this.listenDocumentDestroyed);
        this.document.removeNotificationListener(AttributeChangedEvent.ID, this.listenDocumentAttributeChanged);
        for (ISignatureContainer container : IterableTools.in(this.containerIterator())) {
            this.removeSignatureContainer(container);
        }
    }

    @Override
    public IDocument getDocument() {
        return this.document;
    }

    public IDocumentStateRule getDocumentStateRule() {
        return this.documentStateRule;
    }

    @Override
    public IVSDocument getState() {
        IVSDocument state = this.getDocumentStateRule().createState(this);
        return state;
    }

    private void init(IArgs args) {
        String ruleName;
        switch (ruleName = ArgTools.getString((IArgs)args, (String)ARG_DOCUMENT_STATE_RULE, (String)DOCUMENT_STATE_RULE_ALLVALLID)) {
            case "allValid": {
                this.setDocumentStateRule(new AllSignaturesValidRule());
                break;
            }
            case "mostRecentSignature": {
                this.setDocumentStateRule(new ReferenceSignatureRule());
                break;
            }
            default: {
                this.setDocumentStateRule(new UnknownStateRule());
            }
        }
        this.initSignatureContainers(args);
    }

    protected void initialize() {
        this.document.addNotificationListener(DestroyedEvent.ID, this.listenDocumentDestroyed);
        this.document.addNotificationListener(AttributeChangedEvent.ID, this.listenDocumentAttributeChanged);
        this.triggerChangeEvent();
    }

    private void initSignatureContainers(IArgs args) {
        Stream<ISignatureContainer> containerList = SignatureContainerTools.createSignatureContainers(this.getDocument(), args);
        containerList.forEach(container -> this.addSignatureContainer((ISignatureContainer)container));
    }

    @Override
    public boolean isChanged() {
        return this.getDocument().isChanged();
    }

    public boolean isLicenseRestricted() {
        return this.licenseRestricted;
    }

    protected ISignatureContainer lookupContainer(ILocator locator) {
        if (locator == null) {
            return null;
        }
        for (ISignatureContainer current : IterableTools.in(this.containerIterator())) {
            ILocator currentLocator = current.getLocator();
            if (currentLocator == locator) {
                return current;
            }
            if (currentLocator == null || locator == null || !currentLocator.getPath().equals(locator.getPath())) continue;
            return current;
        }
        return null;
    }

    protected void onDocumentAttributeChanged(AttributeChangedEvent event) {
        if (event.getAttribute() == CommonDocument.ATTR_CHANGED) {
            this.onDocumentChangeChanged();
            return;
        }
    }

    private void onDocumentChangeChanged() {
        if (this.isChanged()) {
            this.releaseStates();
        }
        this.redraw();
        this.triggerChangeEvent();
    }

    private void redraw() {
    }

    protected void releaseStates() {
        for (ISignatureContainer container : IterableTools.in(this.containerIterator())) {
            VSSignatureContainer.setSignatureContainerState((ISignatureContainer)container, null);
        }
    }

    @Override
    public void removeChangeEventListener(INotificationListener listener) {
        this.dispatcher.removeNotificationListener(ChangeEvent.ID, listener);
    }

    @Override
    public synchronized void removeSignatureContainer(ISignatureContainer container) {
        this.basicRemoveSignatureContainer(container);
        this.triggerChangeEvent();
    }

    private void setDocumentStateRule(IDocumentStateRule documentStateRule) {
        this.documentStateRule = documentStateRule;
    }

    public void setLicenseRestricted(boolean licenseRestricted) {
        this.licenseRestricted = licenseRestricted;
    }

    @Override
    public synchronized int size() {
        return this.signatureContainers.size();
    }

    protected void triggerChangeEvent() {
        this.dispatcher.triggerEvent((Event)new ChangeEvent(this));
    }

    @Override
    public IVSDocument validate(IArgs args) {
        this.basicValidate(args, this.isLicenseRestricted());
        return this.getState();
    }

    @Override
    public CompletionStage<IVSDocument> validateAsync(IArgs args) {
        Duration validationTimeout = (Duration)ArgTools.getValue((IArgs)args, (String)ARG_VALIDATION_TIMEOUT, Duration.class, (Object)ValidationEnvironment.get().getDefaultValidationTimeout());
        boolean restricted = this.isLicenseRestricted();
        CompletableFuture completable = new CompletableFuture();
        Future<?> future = ValidationEnvironment.get().getExecutorService().submit(() -> {
            this.basicValidate(args, restricted);
            completable.complete(this.getState());
        });
        return completable.orTimeout(validationTimeout.toMillis(), TimeUnit.MILLISECONDS).exceptionally(t -> {
            future.cancel(true);
            Log.warn(t.getMessage());
            return this.getState();
        });
    }

    public static class ChangeEvent
    extends Event {
        public static final EventType ID = new EventType(ChangeEvent.class.getName());
        private static final long serialVersionUID = 1L;

        public ChangeEvent(Object source) {
            super(source);
        }

        public EventType getEventType() {
            return ID;
        }
    }
}

