/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.validation;

import de.intarsys.security.document.validation.ISignedDocument;
import de.intarsys.security.document.validation.IVSDocument;
import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.DefaultValidationTarget;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.IValidationTarget;
import de.intarsys.tools.string.PrettyPrinter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VSDocument
extends CommonValidationState
implements IVSDocument {
    private boolean recoverable = true;
    private final List states = new ArrayList();

    public static final VSDocument create(ISignedDocument signedDocument) {
        VSDocument docState = new VSDocument(signedDocument);
        Iterator<IVSSignatureContainer> i = signedDocument.containerStateIterator();
        while (i.hasNext()) {
            IVSSignatureContainer state = i.next();
            docState.addContainerState(state);
        }
        return docState;
    }

    public VSDocument(ISignedDocument signedDocument) {
        super((IValidationTarget)new DefaultValidationTarget((Object)signedDocument));
    }

    public VSDocument(ISignedDocument signedDocument, int state) {
        super((IValidationTarget)new DefaultValidationTarget((Object)signedDocument), state);
    }

    public void addContainerState(IVSSignatureContainer containerState) {
        this.states.add(containerState);
    }

    @Override
    public List<IVSSignatureContainer> getSignatureContainerStates() {
        return new ArrayList<IVSSignatureContainer>(this.states);
    }

    @Override
    public ISignedDocument getSignedDocument() {
        return (ISignedDocument)this.getValidationTarget().getImpl();
    }

    public boolean isRecoverable() {
        if (!this.recoverable) {
            return false;
        }
        if (!this.isUnknown()) {
            return false;
        }
        for (IVSSignatureContainer signatureContainerState : this.getSignatureContainerStates()) {
            if (this.isRecoverable((IValidationState)signatureContainerState)) continue;
            return false;
        }
        return true;
    }

    public void setRecoverable(boolean recoverable) {
        this.recoverable = recoverable;
    }

    public void toString(PrettyPrinter printer) {
        super.toString(printer);
        printer.appendMember("containerStates", this.getSignatureContainerStates(), null);
    }
}

