/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.validation;

import de.intarsys.document.model.IDocument;
import de.intarsys.processor.common.CommonProcessor;
import de.intarsys.security.processor.validation.ISignatureContainerProcessor;
import de.intarsys.security.processor.validation.PACKAGE;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;

public abstract class CommonSignatureContainerProcessor
extends CommonProcessor
implements ISignatureContainerProcessor {
    public static final String ARG_DOCUMENT = "document";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private IDocument document;
    private Object documentReferenceHandle;
    private final ISignatureContainer signatureContainer;

    protected CommonSignatureContainerProcessor(IFactory factory, ISignatureContainer pSignatureContainer) {
        super(factory);
        this.signatureContainer = pSignatureContainer;
    }

    protected void acquireResources() throws IOException {
        super.acquireResources();
        if (this.getDocument() != null) {
            this.documentReferenceHandle = this.getDocument().acquire();
        }
    }

    protected void basicRun() throws Exception {
        this.process();
        this.ok();
    }

    public IDocument getDocument() {
        return this.document;
    }

    public ISignatureContainer getSignatureContainer() {
        return this.signatureContainer;
    }

    protected abstract void process() throws Exception;

    protected void releaseResources() {
        super.releaseResources();
        if (this.getDocument() != null) {
            this.getDocument().release(this.documentReferenceHandle);
        }
    }

    public void setDocument(IDocument pDocument) {
        this.document = pDocument;
    }
}

