/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.validation;

import de.intarsys.document.model.IDocument;
import de.intarsys.processor.document.common.CommonDocumentProcessor;
import de.intarsys.security.document.validation.ISignedDocument;
import de.intarsys.security.document.validation.IVSDocument;
import de.intarsys.security.document.validation.SignedDocument;
import de.intarsys.security.processor.validation.PACKAGE;
import de.intarsys.security.processor.validation.SignatureContainerExtenderFactory;
import de.intarsys.security.processor.validation.ValidationProduct;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.progress.IProgressMonitor;
import de.intarsys.tools.reporter.Reporter;

public class DocumentValidationDataExtender
extends CommonDocumentProcessor {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final String ARG_STATE = "state";

    public DocumentValidationDataExtender(IFactory factory, IDocument document) {
        super(factory, document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void basicRun() throws Exception {
        if (!ValidationProduct.isAuthorizedEmbed()) {
            throw new LicenseException("Validation data embedding not licensed!");
        }
        ValidationProduct.withdrawEmbed();
        IProgressMonitor monitor = Reporter.get().reportActivityStart(Msg.getMessage("DocumentValidationDataExtender.activity.extending", new Object[0]), 0);
        try {
            IVSDocument signedDocState = this.getSignedDocumentState();
            for (IVSSignatureContainer containerState : signedDocState.getSignatureContainerStates()) {
                this.extend(containerState);
            }
            this.ok();
        }
        finally {
            monitor.end();
        }
    }

    protected void extend(IVSSignatureContainer containerState) throws FunctorException {
        Args localArgs = Args.create();
        localArgs.put("signatureContainer", (Object)containerState.getSignatureContainer());
        localArgs.put("signatureContainerState", (Object)containerState);
        localArgs.put("document", (Object)this.getDocument());
        FunctorTools.perform((Object)SignatureContainerExtenderFactory.ID, (IArgs)localArgs);
    }

    protected IVSDocument getSignedDocumentState() {
        IVSDocument state = (IVSDocument)this.getArgs().get(ARG_STATE);
        if (state == null) {
            ISignedDocument signedDoc = SignedDocument.getSignedDocument(this.getDocument(), this.getArgs());
            state = signedDoc.getState();
        }
        return state;
    }
}

