/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.validation;

import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.common.IBaseDocumentResolver;
import de.intarsys.document.model.DocumentEnvironment;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.processor.document.standard.AttachmentResolver;
import de.intarsys.security.document.validation.ISignedDocument;
import de.intarsys.security.document.validation.SignedDocument;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.event.DestroyedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import java.io.IOException;

public abstract class ExternallySignedDocumentResolver<T extends IDocument>
implements IBaseDocumentResolver<T> {
    private static final Attribute ATTR_SIGNEDDOCUMENT = new Attribute("signedDocumentInstance");

    protected ExternallySignedDocumentResolver() {
    }

    protected ISignedDocument basicCreateSignedDocument(T signatureDocument) throws IOException {
        ILocator signedDataLocator = this.getSignedContentLocator(signatureDocument);
        IDocument signedDataDoc = this.loadSignedDocument(signedDataLocator);
        ISignatureContainer container = this.createSignatureContainer(signedDataDoc, signatureDocument);
        ISignedDocument signedDocument = SignedDocument.getSignedDocument(signedDataDoc);
        signedDocument.addSignatureContainer(container);
        return signedDocument;
    }

    protected abstract ISignatureContainer createSignatureContainer(IDocument var1, T var2) throws IOException;

    public ISignedDocument createSignedDocument(T signatureDocument) throws IOException {
        ISignedDocument signedDocument = (ISignedDocument)signatureDocument.getAttribute((Object)ATTR_SIGNEDDOCUMENT);
        if (signedDocument == null) {
            signedDocument = this.basicCreateSignedDocument(signatureDocument);
            signatureDocument.setAttribute((Object)ATTR_SIGNEDDOCUMENT, (Object)signedDocument);
            signedDocument.getDocument().addNotificationListener(DestroyedEvent.ID, new INotificationListener(){
                final /* synthetic */ IDocument val$signatureDocument;
                {
                    this.val$signatureDocument = iDocument;
                }

                public void handleEvent(Event event) {
                    this.val$signatureDocument.removeAttribute((Object)ATTR_SIGNEDDOCUMENT);
                }
            });
        } else {
            signedDocument.getDocument().acquire();
        }
        return signedDocument;
    }

    protected ILocator getSignedContentLocator(T signatureDocument) throws IOException {
        return AttachmentResolver.get().getBaseLocator(signatureDocument.getLocator());
    }

    protected IDocument loadSignedDocument(ILocator signedDocLocator) throws IOException {
        IDocumentType documentType;
        if (signedDocLocator == null) {
            try {
                return DocumentTools.createNew((String)"de.intarsys.document.type.unavailable.UnavailableDocumentType", (IArgs)Args.create());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((documentType = DocumentTools.getDocumentTypeForExtensionOrDefault((String)LocatorTools.getExtension((ILocator)signedDocLocator))) == null) {
            throw new IOException("unknown document type '" + signedDocLocator.getPath() + "'");
        }
        IDocument signedDoc = null;
        try {
            signedDoc = documentType.createFromLocator(signedDocLocator, (IArgs)Args.create());
        }
        catch (IOException e) {
            documentType = DocumentEnvironment.get().getDefaultDocumentType();
            signedDoc = documentType.createFromLocator(signedDocLocator, (IArgs)Args.create());
        }
        return signedDoc;
    }

    public IDocument resolveBaseDocument(T attachmentDocument) throws IOException {
        ISignedDocument signedDocument = this.createSignedDocument(attachmentDocument);
        return signedDocument.getDocument();
    }
}

