/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.validation;

import de.intarsys.document.model.DocumentOutlet;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.security.processor.validation.ISignatureContainerResolver;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.function.Predicates;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.streaming.StreamingTools;
import de.intarsys.tools.system.SystemTools;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedSignatureContainerResolver
implements ISignatureContainerResolver,
IElementConfigurable {
    private static final Logger Log = LoggerFactory.getLogger(FileBasedSignatureContainerResolver.class);
    private String documentTypeId;
    private String[] extensions;

    @Override
    public Stream<Object> collectSignatureContainers(IDocument document, IArgs args) {
        Stream<ILocator> externalSignatureLocators = this.searchContainers(document.getLocator());
        return externalSignatureLocators;
    }

    public void configure(IElement element) throws ConfigurationException {
        this.setDocumentTypeId(element.attributeValue("documentType", this.getDocumentTypeId()));
    }

    protected String getDocumentTypeId() {
        return this.documentTypeId;
    }

    public String[] getExtensions() {
        if (this.extensions == null) {
            IDocumentType type = DocumentOutlet.get().lookupDocumentType(this.getDocumentTypeId());
            this.extensions = DocumentOutlet.get().getExtensions(type);
            Arrays.sort(this.extensions);
        }
        return this.extensions;
    }

    protected boolean isFileSystemCaseSensitive() {
        return !SystemTools.isWindows();
    }

    protected Stream<ILocator> searchContainers(ILocator docLocator) {
        ILocator dir = docLocator.getParent();
        if (dir == null) {
            return Stream.empty();
        }
        String typedName = docLocator.getName();
        Stream candidates = this.searchDirect(dir, typedName);
        String baseName = PathTools.getBaseName((String)typedName);
        candidates = Stream.concat(candidates, this.searchDirect(dir, baseName));
        if (this.isFileSystemCaseSensitive()) {
            candidates = StreamingTools.concatIfEmpty(candidates, () -> Stream.concat(new ExtensionLocatorFilter(typedName).search(dir).stream(), new ExtensionLocatorFilter(baseName).search(dir).stream()));
        }
        return candidates;
    }

    protected Stream<ILocator> searchDirect(ILocator parent, String baseName) {
        return Stream.of(this.getExtensions()).map(ext -> parent.getChild(baseName + "." + ext)).filter(Predicates.isNotNull()).filter(loc -> loc.exists() && !loc.isDirectory());
    }

    public void setDocumentTypeId(String documentTypeId) {
        this.documentTypeId = documentTypeId;
    }

    private class ExtensionLocatorFilter
    implements ILocatorNameFilter {
        private String documentName;

        public ExtensionLocatorFilter(String documentName) {
            this.documentName = documentName.toLowerCase();
        }

        public boolean accept(ILocator parent, String name) {
            String lowerCaseName = name.toLowerCase();
            String basename = PathTools.getBaseName((String)lowerCaseName);
            String suffix = PathTools.getExtension((String)lowerCaseName, null, (String)"");
            if (!this.documentName.equals(basename)) {
                return false;
            }
            if (!this.acceptSuffix(suffix)) {
                return false;
            }
            ILocator child = parent.getChild(name);
            return !child.isDirectory();
        }

        protected boolean acceptSuffix(String suffix) {
            return Arrays.binarySearch(FileBasedSignatureContainerResolver.this.getExtensions(), suffix) >= 0;
        }

        public List<ILocator> search(ILocator directory) {
            try {
                ILocator[] candidates = directory.listLocators((ILocatorNameFilter)this);
                if (candidates != null) {
                    return Arrays.asList(candidates);
                }
                return Collections.emptyList();
            }
            catch (IOException e) {
                return Collections.EMPTY_LIST;
            }
        }
    }
}

