/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.processor.validation;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.IExtensionPointHandler;
import de.intarsys.claptz.IInstrumentRegistry;
import de.intarsys.claptz.InstrumentRegistry;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.InstrumentTools;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.security.processor.validation.ISignatureContainerResolver;
import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@SingletonClass
public class SignatureContainerResolverRegistry {
    public static final String XE_RESOLVER = "resolver";
    public static final String XP_RESOLVERS = "com.cabaret.security.validation.signaturecontainerresolvers";
    private static final Logger Log = LoggerFactory.getLogger(SignatureContainerResolverRegistry.class);
    private static final SignatureContainerResolverRegistry Active = new SignatureContainerResolverRegistry();
    private List<ISignatureContainerResolver> resolvers = new ArrayList<ISignatureContainerResolver>();
    private IExtensionPointHandler installResolver = new ExtensionPointHandlerAdapter(){

        protected Object basicInstallInsert(IExtension extension, IElement element) {
            if (SignatureContainerResolverRegistry.XE_RESOLVER.equals(element.getName())) {
                try {
                    ISignatureContainerResolver object = (ISignatureContainerResolver)ElementTools.createObject((IElement)element, ISignatureContainerResolver.class, (Object)extension.getProvider(), (IArgs)Args.create());
                    SignatureContainerResolverRegistry.this.registerResolver(object);
                }
                catch (ObjectCreationException e) {
                    String msg = "error installing extension";
                    this.log(Log, Level.ERROR, extension, element, msg, e);
                }
            } else {
                return super.basicInstallInsert(extension, element);
            }
            return null;
        }
    };

    public static SignatureContainerResolverRegistry get() {
        return Active;
    }

    private SignatureContainerResolverRegistry() {
    }

    public List<ISignatureContainerResolver> getResolvers() {
        this.registerExtensions();
        return this.resolvers;
    }

    protected void registerExtensions() {
        try {
            InstrumentTools.installExtensions((IInstrumentRegistry)InstrumentRegistry.get(), (String)XP_RESOLVERS, (IExtensionPointHandler)this.installResolver);
        }
        catch (InstrumentRegistryException e) {
            Log.warn("error registering extension point 'com.cabaret.security.validation.signaturecontainerresolvers'");
        }
    }

    public void registerResolver(ISignatureContainerResolver resolver) {
        this.resolvers.add(resolver);
    }

    public void unregisterResolver(ISignatureContainerResolver resolver) {
        this.resolvers.remove(resolver);
    }
}

